/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.core;

import com.citrsw.annatation.ApiAppointParam;
import com.citrsw.annatation.ApiBasicReturn;
import com.citrsw.annatation.ApiCode;
import com.citrsw.annatation.ApiIgnore;
import com.citrsw.annatation.ApiMapParam;
import com.citrsw.annatation.ApiMapReturn;
import com.citrsw.annatation.ApiMethod;
import com.citrsw.annatation.ApiParamModelProperty;
import com.citrsw.annatation.ApiReturnModelProperty;
import com.citrsw.common.ApiConstant;
import com.citrsw.core.ParamHandle;
import com.citrsw.core.ReturnHandle;
import com.citrsw.definition.DocCode;
import com.citrsw.definition.DocMethod;
import com.citrsw.definition.DocModel;
import com.citrsw.definition.TempMethod;
import com.citrsw.exception.ApiParamException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
public class MethodHandle {
    private static final Logger log = LoggerFactory.getLogger(MethodHandle.class);
    private final ParamHandle handleParam;
    private final ReturnHandle handleReturn;

    public MethodHandle(ParamHandle handleParam, ReturnHandle handleReturn) {
        this.handleParam = handleParam;
        this.handleReturn = handleReturn;
    }

    public Set<DocMethod> handleMethod(Method[] methods, RequestMapping requestMapping) {
        TreeSet<DocMethod> docMethods = new TreeSet<DocMethod>();
        TreeSet<String> parentModeSet = new TreeSet<String>();
        TreeSet<String> parentUriSet = new TreeSet<String>();
        if (requestMapping != null) {
            if (requestMapping.value().length > 0) {
                parentUriSet.addAll(Arrays.asList(requestMapping.value()));
            }
            if (requestMapping.method().length > 0) {
                for (Method method : requestMapping.method()) {
                    parentModeSet.add(method.name());
                }
            }
        }
        if (parentUriSet.isEmpty()) {
            parentUriSet.add("");
        }
        for (Method method : methods) {
            TreeSet<String> modeSet = new TreeSet<String>((Collection<String>)parentModeSet);
            if (AnnotationUtils.findAnnotation((Method)method, ApiIgnore.class) != null) continue;
            TempMethod tempMethod = new TempMethod();
            ApiMethod methodAnnotation = (ApiMethod)AnnotationUtils.findAnnotation((Method)method, ApiMethod.class);
            if (methodAnnotation != null && StringUtils.isNotBlank((CharSequence)methodAnnotation.value())) {
                tempMethod.setDescription(methodAnnotation.value());
            } else {
                tempMethod.setDescription(method.getName());
            }
            GetMapping getMapping = (GetMapping)AnnotationUtils.findAnnotation((Method)method, GetMapping.class);
            PostMapping postMapping = (PostMapping)AnnotationUtils.findAnnotation((Method)method, PostMapping.class);
            PutMapping putMapping = (PutMapping)AnnotationUtils.findAnnotation((Method)method, PutMapping.class);
            DeleteMapping deleteMapping = (DeleteMapping)AnnotationUtils.findAnnotation((Method)method, DeleteMapping.class);
            RequestMapping requestMappingAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            if (getMapping == null && postMapping == null && putMapping == null && deleteMapping == null && requestMappingAnnotation == null) continue;
            TreeSet<String> uriSet = new TreeSet<String>();
            if (getMapping != null) {
                modeSet.add(RequestMethod.GET.name());
                for (String parentUri : parentUriSet) {
                    for (String value : getMapping.value()) {
                        uriSet.add(parentUri + value);
                    }
                }
            } else if (postMapping != null) {
                modeSet.add(RequestMethod.POST.name());
                for (String parentUri : parentUriSet) {
                    for (String value : postMapping.value()) {
                        uriSet.add(parentUri + value);
                    }
                }
            } else if (putMapping != null) {
                modeSet.add(RequestMethod.PUT.name());
                for (String parentUri : parentUriSet) {
                    for (String value : putMapping.value()) {
                        uriSet.add(parentUri + value);
                    }
                }
            } else if (deleteMapping != null) {
                modeSet.add(RequestMethod.DELETE.name());
                for (String parentUri : parentUriSet) {
                    for (String value : deleteMapping.value()) {
                        uriSet.add(parentUri + value);
                    }
                }
            } else {
                if (requestMappingAnnotation.method().length > 0) {
                    for (RequestMethod requestMethod : requestMappingAnnotation.method()) {
                        modeSet.add(requestMethod.name());
                    }
                } else {
                    modeSet.add(RequestMethod.GET.name());
                    modeSet.add(RequestMethod.HEAD.name());
                    modeSet.add(RequestMethod.POST.name());
                    modeSet.add(RequestMethod.PUT.name());
                    modeSet.add(RequestMethod.PATCH.name());
                    modeSet.add(RequestMethod.DELETE.name());
                    modeSet.add(RequestMethod.OPTIONS.name());
                    modeSet.add(RequestMethod.TRACE.name());
                }
                for (String parentUri : parentUriSet) {
                    for (String value : requestMappingAnnotation.value()) {
                        uriSet.add(parentUri + value);
                    }
                }
            }
            tempMethod.setModeSet(modeSet);
            tempMethod.setUriSet(uriSet);
            ApiMapParam apiMapParam = (ApiMapParam)AnnotationUtils.findAnnotation((Method)method, ApiMapParam.class);
            ApiAppointParam apiAppointParam = (ApiAppointParam)AnnotationUtils.findAnnotation((Method)method, ApiAppointParam.class);
            ApiParamModelProperty[] apiModelProperties = (ApiParamModelProperty[])method.getAnnotationsByType(ApiParamModelProperty.class);
            Parameter[] parameters = method.getParameters();
            try {
                DocModel paramDocModel = this.handleParam.handleParam(apiMapParam, apiAppointParam, apiModelProperties, parameters);
                tempMethod.setParamDocModel(paramDocModel);
            }
            catch (ApiParamException e) {
                log.error("\u65b9\u6cd5{}{}", (Object)method.getName(), (Object)e.getMessage());
                continue;
            }
            ApiMapReturn apiMapReturn = (ApiMapReturn)AnnotationUtils.findAnnotation((Method)method, ApiMapReturn.class);
            ApiBasicReturn apiBasicReturn = (ApiBasicReturn)AnnotationUtils.findAnnotation((Method)method, ApiBasicReturn.class);
            ApiReturnModelProperty[] apiReturnModelProperties = (ApiReturnModelProperty[])method.getAnnotationsByType(ApiReturnModelProperty.class);
            Class<?> returnType = method.getReturnType();
            if (!"void".equals(returnType.getName())) {
                Type genericReturnType = method.getGenericReturnType();
                DocModel returnDocModel = this.handleReturn.handleReturn(apiMapReturn, apiBasicReturn, returnType, genericReturnType, apiReturnModelProperties);
                tempMethod.setReturnDocModel(returnDocModel);
            }
            TreeSet<DocCode> docCodes = new TreeSet<DocCode>();
            ApiCode[] apiCodeAnnotations = (ApiCode[])method.getAnnotationsByType(ApiCode.class);
            if (apiCodeAnnotations.length > 0) {
                for (ApiCode apiCodeAnnotation : apiCodeAnnotations) {
                    String name = apiCodeAnnotation.name();
                    String value = apiCodeAnnotation.value();
                    String description = apiCodeAnnotation.description();
                    DocCode docCode = new DocCode();
                    docCode.setName(name);
                    docCode.setValue(value);
                    docCode.setDescription(description);
                    docCodes.add(docCode);
                }
            }
            docCodes.addAll(ApiConstant.DOC_GLOBAL_CODES);
            tempMethod.setDocCodes(docCodes);
            DocMethod docMethod = new DocMethod();
            docMethod.setDescription(tempMethod.getDescription());
            docMethod.setParamRequireMap(tempMethod.getParamRequireMap());
            docMethod.setModeSet(tempMethod.getModeSet());
            docMethod.setUriSet(tempMethod.getUriSet());
            docMethod.setParams(tempMethod.getParams());
            docMethod.setParamJson(tempMethod.getParamJson());
            docMethod.setParamExample(tempMethod.getParamExample());
            docMethod.setParamAndroid(tempMethod.getParamAndroid());
            docMethod.setParamIos(tempMethod.getParamIos());
            docMethod.setParamVue(tempMethod.getParamVue());
            docMethod.setReturnJson(tempMethod.getReturnJson());
            docMethod.setReturnAndroid(tempMethod.getReturnAndroid());
            docMethod.setReturnIos(tempMethod.getReturnIos());
            docMethod.setReturnVue(tempMethod.getReturnVue());
            docMethod.setDocCodes(tempMethod.getDocCodes());
            docMethods.add(docMethod);
            for (String uri : uriSet) {
                for (String mode : modeSet) {
                    ApiConstant.methodMap.put(method.getDeclaringClass().getName() + "#" + mode.toUpperCase() + "#" + uri, tempMethod);
                }
            }
        }
        return docMethods;
    }
}

