/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.definition;

import com.citrsw.common.ApiUtils;
import com.citrsw.definition.DocModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DocProperty
implements Comparable<DocProperty> {
    private String name;
    @JsonIgnore
    private String className;
    private String description;
    private String type = "";
    private String format;
    private Boolean requited;
    @JsonProperty(value="default_value")
    private String defaultValue;
    private String example;
    private DocModel docModel;

    public Set<DocProperty> param(DocProperty parentDocProperty, Map<String, DocProperty> paramRequireMap) {
        LinkedHashSet<DocProperty> apiProperties = new LinkedHashSet<DocProperty>();
        if (this.docModel != null && !this.docModel.getApiProperties().isEmpty()) {
            for (DocProperty docProperty : this.docModel.getApiProperties()) {
                DocProperty property = new DocProperty();
                property.setName(docProperty.getName());
                property.setDescription(docProperty.getDescription());
                String typeName = docProperty.getType();
                if (docProperty.getDocModel() != null) {
                    typeName = typeName.replaceAll("\\[0\\]", "[]");
                }
                property.setType(typeName);
                property.setFormat(docProperty.getFormat());
                property.setRequited(docProperty.getRequited());
                property.setDefaultValue(docProperty.getDefaultValue());
                property.setExample(docProperty.getExample());
                property.setDocModel(docProperty.getDocModel());
                try {
                    String newName = StringUtils.isNotBlank((CharSequence)property.getName()) ? "." + property.getName() : "";
                    property.setName(parentDocProperty.getName() + parentDocProperty.getType().replaceAll(parentDocProperty.getType().replaceAll("\\[0\\]", "").replaceAll("\\[\\]", ""), "") + newName);
                    if (docProperty.getRequited() != null && docProperty.getRequited().booleanValue()) {
                        paramRequireMap.put(property.getName(), docProperty);
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                apiProperties.addAll(property.param(property, paramRequireMap));
            }
        } else {
            parentDocProperty.setType(parentDocProperty.getType().replaceAll("\\[0\\]", "[]"));
            apiProperties.add(parentDocProperty);
        }
        return apiProperties;
    }

    public String getJson(String superName, StringBuilder tabs, boolean isParam, boolean isExample, Map<String, DocProperty> paramRequireMap) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.name) && this.docModel == null && StringUtils.isBlank((CharSequence)this.type.replaceAll("\\[0\\]", ""))) {
            return "";
        }
        superName = StringUtils.isNotBlank((CharSequence)superName) ? superName + "." + this.name : this.name;
        builder.append("\r\n").append((CharSequence)tabs);
        if (isExample) {
            builder.append("\"");
        }
        builder.append(this.name);
        if (isExample) {
            builder.append("\"");
        }
        builder.append(": ");
        if (this.docModel != null && !this.docModel.getApiProperties().isEmpty()) {
            if (this.type.contains("[0]")) {
                String[] split = this.type.split("0\\]");
                StringBuilder tabBuilder = new StringBuilder(tabs);
                for (int i = 0; i < split.length; ++i) {
                    builder.append("[").append("\r\n").append((CharSequence)tabs);
                    for (int j = 0; j <= i; ++j) {
                        builder.append("    ");
                        tabBuilder.append("    ");
                    }
                }
                builder.append("{");
                if (StringUtils.isNotBlank((CharSequence)this.description) && !isExample) {
                    builder.append(" //").append(this.description);
                }
                Iterator<DocProperty> it = this.docModel.getApiProperties().iterator();
                while (it.hasNext()) {
                    DocProperty docProperty = it.next();
                    String json = docProperty.getJson(superName, new StringBuilder(tabBuilder).append("    "), isParam, isExample, paramRequireMap);
                    if (!(json.contains("[") || json.contains("{") || it.hasNext())) {
                        json = json.replaceFirst(",", "");
                    }
                    builder.append(json);
                    if (!json.endsWith("}") && !json.endsWith("]") || !it.hasNext()) continue;
                    builder.append(",");
                }
                builder.append("\r\n").append((CharSequence)tabBuilder).append("}").append("\r\n");
                if (tabBuilder.length() > 0) {
                    tabBuilder.delete(tabBuilder.length() - 4, tabBuilder.length());
                }
                for (int i = split.length; i > 0; --i) {
                    for (int j = i - 1; j > 0; --j) {
                        builder.append("    ");
                    }
                    builder.append((CharSequence)tabs).append("]").append("\r\n");
                }
                builder.deleteCharAt(builder.length() - 1);
                builder.deleteCharAt(builder.length() - 1);
                return builder.toString();
            }
            builder.append("{");
            if (StringUtils.isNotBlank((CharSequence)this.description) && !isExample) {
                builder.append(" //").append(this.description);
            }
            Iterator<DocProperty> it = this.docModel.getApiProperties().iterator();
            while (it.hasNext()) {
                DocProperty docProperty = it.next();
                String json = docProperty.getJson(superName, new StringBuilder(tabs).append("    "), isParam, isExample, paramRequireMap);
                if (!(json.contains("[") || json.contains("{") || it.hasNext())) {
                    json = json.replaceFirst(",", "");
                }
                builder.append(json);
                if (!json.endsWith("}") && !json.endsWith("]") || !it.hasNext()) continue;
                builder.append(",");
            }
            builder.append("\r\n").append((CharSequence)tabs).append("}");
            return builder.toString();
        }
        if (isExample) {
            if (StringUtils.isBlank((CharSequence)this.type)) {
                builder.append("null,");
            } else if (this.type.contains("[0]")) {
                builder.append("[],");
            } else {
                builder.append("\"");
                if (StringUtils.isNotBlank((CharSequence)this.defaultValue)) {
                    builder.append(this.defaultValue);
                }
                builder.append("\",");
            }
            return builder.toString();
        }
        if (this.type.contains("[0]")) {
            if (StringUtils.isBlank((CharSequence)this.type.replaceAll("\\[0\\]", ""))) {
                builder.append("null").append(", //");
            } else {
                int i;
                String[] split = this.type.split("0\\]");
                for (i = 0; i < split.length; ++i) {
                    builder.append("[");
                }
                builder.append("\"");
                if (StringUtils.isNotBlank((CharSequence)this.defaultValue)) {
                    builder.append(this.defaultValue);
                }
                builder.append("\"");
                for (i = 0; i < split.length; ++i) {
                    builder.append("]");
                }
                builder.append(", //").append(this.type.replaceAll("\\[0\\]", "[]"));
                if (StringUtils.isNotBlank((CharSequence)this.description) || StringUtils.isNotBlank((CharSequence)this.format) || isParam) {
                    builder.append(" | ");
                }
            }
        } else if (StringUtils.isBlank((CharSequence)this.type)) {
            builder.append("null").append(", //");
        } else {
            builder.append("\"");
            if (StringUtils.isNotBlank((CharSequence)this.defaultValue)) {
                builder.append(this.defaultValue);
            }
            builder.append("\"");
            builder.append(", //").append(this.type);
            if (StringUtils.isNotBlank((CharSequence)this.description) || StringUtils.isNotBlank((CharSequence)this.format) || isParam) {
                builder.append(" | ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            builder.append(this.description);
            if (isParam) {
                builder.append(" | ");
            }
        }
        if (isParam) {
            if (paramRequireMap != null && this.requited != null && this.requited.booleanValue()) {
                paramRequireMap.put(superName, this);
            }
            builder.append(this.requited != null && this.requited != false ? "\u5fc5\u4f20" : "\u975e\u5fc5\u4f20");
            if (StringUtils.isNotBlank((CharSequence)this.format)) {
                builder.append(" | ").append(this.format);
            }
            if (StringUtils.isNotBlank((CharSequence)this.example)) {
                builder.append(" | ").append(this.example);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.format)) {
            builder.append(" | ").append(this.format);
        }
        return builder.toString();
    }

    public String android(Set<String> strings) {
        if (this.docModel != null && !this.docModel.getApiProperties().isEmpty()) {
            StringBuilder classNameBuilder;
            this.docModel.android(strings);
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.description)) {
                builder.append("\n\n    /**\r\n     * ").append(this.description).append("\r\n     */");
            }
            if (StringUtils.isBlank((CharSequence)this.className) || this.className.startsWith("Map")) {
                classNameBuilder = new StringBuilder("Map<String, ");
                classNameBuilder.append(this.docModel.getApiProperties().iterator().next().className);
                classNameBuilder.append(">");
            } else {
                classNameBuilder = new StringBuilder(this.className);
                if (this.type.contains("[0]")) {
                    int i;
                    classNameBuilder = new StringBuilder("List");
                    String[] split = this.type.split("0\\]");
                    for (i = 0; i < split.length; ++i) {
                        classNameBuilder.append("<");
                    }
                    classNameBuilder.append(this.className);
                    for (i = 0; i < split.length; ++i) {
                        classNameBuilder.append(">");
                    }
                }
            }
            builder.append("\r\n    private").append(" ").append((CharSequence)classNameBuilder).append(" ").append(this.name).append(";");
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            builder.append("\n\n    /**\r\n     * ").append(this.description).append("\r\n     */");
        }
        if (this.className == null) {
            System.out.println(1);
        }
        StringBuilder classNameBuilder = new StringBuilder(this.className);
        if (this.type.contains("[0]")) {
            int i;
            classNameBuilder = new StringBuilder("List");
            String[] split = this.type.split("0\\]");
            for (i = 0; i < split.length; ++i) {
                classNameBuilder.append("<");
            }
            classNameBuilder.append(this.className);
            for (i = 0; i < split.length; ++i) {
                classNameBuilder.append(">");
            }
        }
        builder.append("\r\n    private").append(" ").append((CharSequence)classNameBuilder).append(" ").append(this.name).append(";");
        return builder.toString();
    }

    public String ios(Set<String> strings) {
        String iosType = ApiUtils.javaToIosType(this.className);
        String string = iosType = StringUtils.isBlank((CharSequence)iosType) ? this.className : iosType;
        if (this.docModel != null && !this.docModel.getApiProperties().isEmpty()) {
            StringBuilder classNameBuilder;
            this.docModel.ios(strings);
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.description)) {
                builder.append("\n\n    /**\r\n     * ").append(this.description).append("\r\n     */");
            }
            if (StringUtils.isBlank((CharSequence)this.className) || this.className.startsWith("Map")) {
                classNameBuilder = new StringBuilder("[String: ");
                String className = ApiUtils.javaToIosType(this.docModel.getApiProperties().iterator().next().className);
                className = StringUtils.isBlank((CharSequence)className) ? this.className : className;
                classNameBuilder.append(className);
                classNameBuilder.append("]");
            } else {
                classNameBuilder = new StringBuilder(iosType);
                if (this.type.contains("[0]")) {
                    int i;
                    classNameBuilder = new StringBuilder();
                    String[] split = this.type.split("0\\]");
                    for (i = 0; i < split.length; ++i) {
                        classNameBuilder.append("[");
                    }
                    classNameBuilder.append(iosType);
                    for (i = 0; i < split.length; ++i) {
                        classNameBuilder.append("]");
                    }
                    classNameBuilder.append(" = []");
                }
            }
            builder.append("\r\n    var").append(" ").append(this.name).append(": ").append((CharSequence)classNameBuilder);
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            builder.append("\n\n    /**\r\n     * ").append(this.description).append("\r\n     */");
        }
        StringBuilder classNameBuilder = new StringBuilder(iosType);
        if (this.type.contains("[0]")) {
            int i;
            classNameBuilder = new StringBuilder();
            String[] split = this.type.split("0\\]");
            for (i = 0; i < split.length; ++i) {
                classNameBuilder.append("[");
            }
            classNameBuilder.append(iosType);
            for (i = 0; i < split.length; ++i) {
                classNameBuilder.append("]");
            }
            classNameBuilder.append(" = []");
        }
        builder.append("\r\n    var").append(" ").append(this.name).append(": ").append((CharSequence)classNameBuilder);
        return builder.toString();
    }

    @Override
    public int compareTo(DocProperty o) {
        if (StringUtils.isNotBlank((CharSequence)o.name) && StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name.compareTo(o.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return 1;
        }
        if (StringUtils.isNotBlank((CharSequence)o.name)) {
            return -1;
        }
        return 0;
    }

    public String paramVue(StringBuilder rulesBuilder, StringBuilder htmlBuilder, String className, Map<String, Map<String, String>> mapList) {
        if (this.docModel == null) {
            if (!this.type.contains("[0]")) {
                htmlBuilder.append("        ").append("<el-form-item");
                if (StringUtils.isNotBlank((CharSequence)this.description)) {
                    htmlBuilder.append(" label=\"").append(this.description).append("\"");
                }
                htmlBuilder.append(" prop=\"").append(this.name).append("\">").append("\r\n");
                htmlBuilder.append("            ").append("<el-input v-model=\"").append(className).append(".").append(this.name).append("\"");
                if (StringUtils.isNotBlank((CharSequence)this.description)) {
                    htmlBuilder.append(" placeholder=\"").append(this.description).append("\"");
                }
                htmlBuilder.append("></el-input>").append("\r\n");
                htmlBuilder.append("        ").append("</el-form-item>").append("\r\n");
            }
        } else {
            this.docModel.paramVue(mapList);
        }
        rulesBuilder.append("        ").append(this.name).append(": [").append("\r\n");
        rulesBuilder.append("          ").append("{required: true, message: '\u8bf7\u8f93\u5165");
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            rulesBuilder.append(this.description);
        }
        rulesBuilder.append("', trigger: 'blur'}").append("\r\n");
        rulesBuilder.append("        ").append("],").append("\r\n");
        return rulesBuilder.toString();
    }

    public void returnVue(StringBuilder builder, String className, Map<String, Map<String, String>> mapList) {
        if (this.docModel == null) {
            if (!this.type.contains("[0]")) {
                builder.append("    ").append("<el-table-column").append("\r\n");
                if (StringUtils.isNotBlank((CharSequence)this.description)) {
                    builder.append("        ").append("label=\"").append(this.description).append("\"").append("\r\n");
                }
                builder.append("        ").append("prop=\"").append(this.name).append("\">").append("\r\n");
                builder.append("    ").append("</el-table-column>").append("\r\n");
            }
        } else {
            this.docModel.returnVue(mapList);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public Boolean getRequited() {
        return this.requited;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExample() {
        return this.example;
    }

    public DocModel getDocModel() {
        return this.docModel;
    }

    public DocProperty setName(String name) {
        this.name = name;
        return this;
    }

    @JsonIgnore
    public DocProperty setClassName(String className) {
        this.className = className;
        return this;
    }

    public DocProperty setDescription(String description) {
        this.description = description;
        return this;
    }

    public DocProperty setType(String type) {
        this.type = type;
        return this;
    }

    public DocProperty setFormat(String format) {
        this.format = format;
        return this;
    }

    public DocProperty setRequited(Boolean requited) {
        this.requited = requited;
        return this;
    }

    @JsonProperty(value="default_value")
    public DocProperty setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DocProperty setExample(String example) {
        this.example = example;
        return this;
    }

    public DocProperty setDocModel(DocModel docModel) {
        this.docModel = docModel;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocProperty)) {
            return false;
        }
        DocProperty other = (DocProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$requited = this.getRequited();
        Boolean other$requited = other.getRequited();
        if (this$requited == null ? other$requited != null : !((Object)this$requited).equals(other$requited)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$example = this.getExample();
        String other$example = other.getExample();
        if (this$example == null ? other$example != null : !this$example.equals(other$example)) {
            return false;
        }
        DocModel this$docModel = this.getDocModel();
        DocModel other$docModel = other.getDocModel();
        return !(this$docModel == null ? other$docModel != null : !((Object)this$docModel).equals(other$docModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $requited = this.getRequited();
        result = result * 59 + ($requited == null ? 43 : ((Object)$requited).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $example = this.getExample();
        result = result * 59 + ($example == null ? 43 : $example.hashCode());
        DocModel $docModel = this.getDocModel();
        result = result * 59 + ($docModel == null ? 43 : ((Object)$docModel).hashCode());
        return result;
    }

    public String toString() {
        return "DocProperty(name=" + this.getName() + ", className=" + this.getClassName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", format=" + this.getFormat() + ", requited=" + this.getRequited() + ", defaultValue=" + this.getDefaultValue() + ", example=" + this.getExample() + ", docModel=" + this.getDocModel() + ")";
    }
}

