/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.common;

import com.citrsw.common.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ApiUtils {
    private static final Map<String, String> TYPE_MAP = new HashMap<String, String>();

    public static String javaToIosType(String className) {
        return TYPE_MAP.get(className);
    }

    public static Type regenerateType(Type returnType) {
        if (returnType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)returnType;
            Type rawType = pType.getRawType();
            ArrayList<Type> types = new ArrayList<Type>();
            for (Type actualTypeArgument : pType.getActualTypeArguments()) {
                types.add(ApiUtils.regenerateType(actualTypeArgument));
            }
            return ParameterizedTypeImpl.make((Class)rawType, types.toArray(new Type[0]), null);
        }
        return returnType;
    }

    public static String getLocalIp() throws Exception {
        String localip = null;
        String netip = null;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean finded = false;
        block0: while (netInterfaces.hasMoreElements() && !finded) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                InetAddress ip = address.nextElement();
                if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                    netip = ip.getHostAddress();
                    finded = true;
                    continue block0;
                }
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                localip = ip.getHostAddress();
            }
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    static {
        TYPE_MAP.put("Integer", "Int");
        TYPE_MAP.put("int", "Int");
        TYPE_MAP.put("Long", "Int");
        TYPE_MAP.put("long", "Int");
        TYPE_MAP.put("Boolean", "Bool");
        TYPE_MAP.put("boolean", "Bool");
        TYPE_MAP.put("Float", "Float");
        TYPE_MAP.put("float", "Float");
        TYPE_MAP.put("Double", "Double");
        TYPE_MAP.put("double", "Double");
        TYPE_MAP.put("String", "String");
        TYPE_MAP.put("Date", "Date");
        TYPE_MAP.put("LocalDateTime", "Date");
        TYPE_MAP.put("LocalDate", "Date");
        TYPE_MAP.put("LocalTime", "Date");
        TYPE_MAP.put("short", "short");
        TYPE_MAP.put("Object", "Any");
        TYPE_MAP.put("MultipartFile", "[Int]");
    }
}

