/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.core;

import com.citrsw.annatation.ApiEnable;
import com.citrsw.annatation.ApiGlobalClass;
import com.citrsw.annatation.ApiGlobalCode;
import com.citrsw.annatation.ApiProperty;
import com.citrsw.common.ApiConstant;
import com.citrsw.common.ApiUtils;
import com.citrsw.core.ControllerHandle;
import com.citrsw.definition.Doc;
import com.citrsw.definition.DocClass;
import com.citrsw.definition.DocCode;
import com.citrsw.enumeration.TypeEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.stereotype.Component;

@Component
public class ApiContext
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ApiContext.class);
    @Value(value="${spring.profiles.active:}")
    private String active;
    @Value(value="${server.port:8080}")
    private String port;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Value(value="${spring.mvc.servlet.path:}")
    private String servletPath;
    @Value(value="${server.ssl.enabled:false}")
    private Boolean sslEnabled;
    private final ControllerHandle controllerHandle;
    private Doc doc;

    public ApiContext(ControllerHandle controllerHandle) {
        this.controllerHandle = controllerHandle;
    }

    public Doc getDoc() {
        return this.doc;
    }

    /*
     * WARNING - void declaration
     */
    public void run(String ... args) {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                void var15_23;
                ApiGlobalCode[] apiGlobalCodes;
                ApiGlobalClass[] apiGlobalClasses;
                if (!"main".equals(stackTraceElement.getMethodName())) continue;
                Class<?> mainApplicationClass = Class.forName(stackTraceElement.getClassName());
                ApiEnable apiEnable = mainApplicationClass.getAnnotation(ApiEnable.class);
                if (apiEnable == null) {
                    return;
                }
                log.info("======Api\u542f\u52a8======");
                boolean pass = true;
                String[] actives = apiEnable.actives();
                if (actives.length > 0 && StringUtils.isNotBlank((CharSequence)this.active)) {
                    pass = false;
                    for (String active : actives) {
                        if (!active.equals(this.active)) continue;
                        pass = true;
                        break;
                    }
                    if (!pass) {
                        ApiConstant.apiEnable = false;
                        log.warn("Api\u5df2\u7981\u7528,\u5f53\u524d\u542f\u52a8\u73af\u5883\u4e3a[{}],api\u6307\u5b9a\u73af\u5883\u4e3a{}", (Object)this.active, (Object)actives);
                        return;
                    }
                } else {
                    log.warn("\u672a\u914d\u7f6e\u542f\u52a8\u73af\u5883,\u5df2\u9002\u7528\u5168\u90e8\u73af\u5883");
                }
                ApiConstant.underscore = apiEnable.underscore();
                for (ApiGlobalClass apiGlobalClass : apiGlobalClasses = (ApiGlobalClass[])mainApplicationClass.getAnnotationsByType(ApiGlobalClass.class)) {
                    Map<Object, Object> apiPropertyMap;
                    String description = apiGlobalClass.description();
                    if (TypeEnum.PARAM.equals((Object)apiGlobalClass.type())) {
                        if (StringUtils.isNotBlank((CharSequence)description)) {
                            ApiConstant.PARAM_GLOBAL_CLASS_DESCRIPTION_MAP.put(apiGlobalClass.name(), description);
                        }
                        for (ApiProperty property : apiGlobalClass.properties()) {
                            if (ApiConstant.PARAM_GLOBAL_CLASS_MAP.containsKey(apiGlobalClass.name())) {
                                apiPropertyMap = ApiConstant.PARAM_GLOBAL_CLASS_MAP.get(apiGlobalClass.name());
                                apiPropertyMap.put(property.name(), property);
                                continue;
                            }
                            apiPropertyMap = new HashMap(256);
                            apiPropertyMap.put(property.name(), property);
                            ApiConstant.PARAM_GLOBAL_CLASS_MAP.put(apiGlobalClass.name(), apiPropertyMap);
                        }
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)description)) {
                        ApiConstant.RETURN_GLOBAL_CLASS_DESCRIPTION_MAP.put(apiGlobalClass.name(), description);
                    }
                    for (ApiProperty property : apiGlobalClass.properties()) {
                        if (ApiConstant.RETURN_GLOBAL_CLASS_MAP.containsKey(apiGlobalClass.name())) {
                            apiPropertyMap = ApiConstant.RETURN_GLOBAL_CLASS_MAP.get(apiGlobalClass.name());
                            apiPropertyMap.put(property.name(), property);
                            continue;
                        }
                        apiPropertyMap = new HashMap(256);
                        apiPropertyMap.put(property.name(), property);
                        ApiConstant.RETURN_GLOBAL_CLASS_MAP.put(apiGlobalClass.name(), apiPropertyMap);
                    }
                }
                ApiGlobalCode[] apiGlobalCodeArray = apiGlobalCodes = (ApiGlobalCode[])mainApplicationClass.getAnnotationsByType(ApiGlobalCode.class);
                int active = apiGlobalCodeArray.length;
                boolean bl = false;
                while (var15_23 < active) {
                    ApiGlobalCode apiGlobalCode = apiGlobalCodeArray[var15_23];
                    String name = apiGlobalCode.name();
                    String value = apiGlobalCode.value();
                    String description = apiGlobalCode.description();
                    DocCode docCode = new DocCode();
                    docCode.setName(name);
                    docCode.setValue(value);
                    docCode.setDescription(description);
                    ApiConstant.DOC_GLOBAL_CODES.add(docCode);
                    ++var15_23;
                }
                List<String> packages = this.controllerHandle.takePackages(mainApplicationClass);
                HashSet classes = new HashSet();
                for (String packageName : packages) {
                    this.controllerHandle.scanner(packageName, classes);
                }
                SpringBootApplication springBootApplication = mainApplicationClass.getAnnotation(SpringBootApplication.class);
                Object[] scanClasses = springBootApplication.scanBasePackageClasses();
                if (scanClasses.length > 0) {
                    log.info("\u5df2\u83b7\u53d6applicationClassAnnotation\u914d\u7f6e\u4e2d\u9700\u8981\u626b\u63cf\u7684\u7c7b:{}", (Object)Arrays.toString(scanClasses));
                    classes.addAll(Arrays.asList(scanClasses));
                }
                log.info("\u5df2\u83b7\u53d6\u5230\u6240\u6709\u9700\u8981\u626b\u63cf\u7684Controller\u7c7b({})\u4e2a\uff1a{}", (Object)classes.size(), classes);
                Set<DocClass> docClasses = this.controllerHandle.handleClass(classes);
                this.doc = new Doc().setDocClasses(docClasses);
                this.doc.setTokenName(apiEnable.tokenName());
                if (StringUtils.isNotBlank((CharSequence)apiEnable.name())) {
                    this.doc.setName(apiEnable.name());
                }
                System.out.println("\n       __                  ___          _ ____                 \n      / /___ __   ______ _/   |  ____  (_) __ \\____  __________\n __  / / __ `/ | / / __ `/ /| | / __ \\/ / / / / __ \\/ ___/ ___/\n/ /_/ / /_/ /| |/ / /_/ / ___ |/ /_/ / / /_/ / /_/ / /__(__  ) \n\\____/\\__,_/ |___/\\__,_/_/  |_/ .___/_/_____/\\____/\\___/____/  \n                             /_/                               \n                                                  1.6.8-jdk1.8   \n");
                try {
                    String ip = ApiUtils.getLocalIp();
                    String uri = ip + ":" + this.port + this.contextPath + this.servletPath + "/citrsw/index.html";
                    uri = uri.replaceAll("//", "/");
                    System.out.println("\u5185\u7f51Api\u8bbf\u95ee\u5730\u5740\uff1a  " + (this.sslEnabled != false ? "https" : "http") + "://" + uri);
                }
                catch (Exception ip) {
                    // empty catch block
                }
                String uri = this.port + this.contextPath + this.servletPath + "/citrsw/index.html";
                uri = uri.replaceAll("//", "/");
                System.out.println("\u672c\u5730Api\u8bbf\u95ee\u5730\u5740\uff1a  " + (this.sslEnabled != false ? "https" : "http") + "://127.0.0.1:" + uri);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("======Api\u89e3\u6790\u5f02\u5e38======");
        }
    }
}

