/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.core;

import com.citrsw.definition.Doc;
import com.citrsw.definition.DocClass;
import com.citrsw.definition.DocCode;
import com.citrsw.definition.DocMethod;
import com.citrsw.definition.DocProperty;
import org.apache.commons.lang3.StringUtils;

public class MarkdownHandler {
    private final StringBuffer buffer = new StringBuffer();

    public String generate(Doc doc) {
        String name = doc.getName();
        this.buffer.append("# ").append(name).append("\n");
        this.buffer.append("[TOC]").append("\n");
        for (DocClass docClass : doc.getDocClasses()) {
            this.creatClass(docClass);
        }
        return this.buffer.toString();
    }

    private void creatClass(DocClass docClass) {
        this.buffer.append("## ").append(docClass.getDescription()).append("\n");
        for (DocMethod docMethod : docClass.getDocMethods()) {
            this.creatMethod(docMethod);
        }
    }

    private void creatMethod(DocMethod docMethod) {
        this.buffer.append("### ").append(docMethod.getDescription()).append("\n");
        this.buffer.append("***\u8bf7\u6c42\u5730\u5740***").append("\n");
        for (String uri : docMethod.getUriSet()) {
            this.buffer.append("`").append(uri).append("`");
            for (String mode : docMethod.getModeSet()) {
                this.buffer.append("**").append(mode).append("** ");
            }
            this.buffer.append("\n");
        }
        this.buffer.append("***\u8bf7\u6c42\u53c2\u6570***").append("\n");
        if (docMethod.getParams() != null && !docMethod.getParams().isEmpty()) {
            this.buffer.append("| \u53c2\u6570\u540d | \u7c7b\u578b | \u662f\u5426\u5fc5\u4f20 | \u63cf\u8ff0 | \u683c\u5f0f | \u9ed8\u8ba4\u503c | \u793a\u4f8b |").append("\n");
            this.buffer.append("| :----- | :--- | :------- | :--- | :--- | :----- | :--- |").append("\n");
            for (DocProperty param : docMethod.getParams()) {
                this.buffer.append("|").append(param.getName()).append("|").append(param.getType()).append("|").append(param.getRequited() != null && param.getRequited() != false ? "\u662f" : "\u5426").append("|").append(StringUtils.isNotBlank((CharSequence)param.getDescription()) ? param.getDescription() : "").append("|").append(StringUtils.isNotBlank((CharSequence)param.getFormat()) ? param.getFormat() : "").append("|").append(StringUtils.isNotBlank((CharSequence)param.getDefaultValue()) ? param.getDefaultValue() : "").append("|").append(StringUtils.isNotBlank((CharSequence)param.getExample()) ? param.getExample() : "").append("| ").append("\n");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)docMethod.getParamJson())) {
            this.buffer.append("```json").append("\n");
            this.buffer.append(docMethod.getParamJson()).append("\n");
            this.buffer.append("```").append("\n");
        }
        this.buffer.append("\n").append("***\u54cd\u5e94***").append("\n");
        if (StringUtils.isNotBlank((CharSequence)docMethod.getReturnJson())) {
            this.buffer.append("```json").append("\n");
            this.buffer.append(docMethod.getReturnJson()).append("\n");
            this.buffer.append("```").append("\n");
        }
        this.buffer.append("***\u72b6\u6001\u7801***").append("\n");
        if (docMethod.getDocCodes() != null && !docMethod.getDocCodes().isEmpty()) {
            this.buffer.append("| \u53c2\u6570\u540d | \u503c | \u63cf\u8ff0 |").append("\n");
            this.buffer.append("| :----- | :--- | :------- |").append("\n");
            for (DocCode docCode : docMethod.getDocCodes()) {
                this.buffer.append("|").append(docCode.getName()).append("|").append(docCode.getValue()).append("|").append(StringUtils.isNotBlank((CharSequence)docCode.getDescription()) ? docCode.getDescription() : "").append("| ").append("\n");
            }
        }
    }
}

