/*
 * Decompiled with CFR 0.152.
 */
package com.citrsw.definition;

import com.citrsw.definition.DocProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class DocModel {
    private String description;
    private String type;
    @JsonIgnore
    private String className;
    private Set<DocProperty> apiProperties = new TreeSet<DocProperty>();
    private String form;

    public Set<DocProperty> params(Map<String, DocProperty> paramRequireMap) {
        if (StringUtils.isNotBlank((CharSequence)this.form) && "json".equals(this.form)) {
            return new LinkedHashSet<DocProperty>();
        }
        if (StringUtils.isNotBlank((CharSequence)this.type) && !this.type.contains("[0]")) {
            DocProperty docProperty = this.apiProperties.iterator().next();
            if (docProperty.getRequited() != null && docProperty.getRequited().booleanValue()) {
                paramRequireMap.put(docProperty.getName(), docProperty);
            }
            return this.apiProperties;
        }
        LinkedHashSet<DocProperty> apiProperties = new LinkedHashSet<DocProperty>();
        for (DocProperty docProperty : this.apiProperties) {
            DocProperty property = new DocProperty();
            property.setName(docProperty.getName());
            property.setDescription(docProperty.getDescription());
            property.setType(docProperty.getType());
            property.setFormat(docProperty.getFormat());
            property.setRequited(docProperty.getRequited());
            property.setDefaultValue(docProperty.getDefaultValue());
            property.setExample(docProperty.getExample());
            property.setDocModel(docProperty.getDocModel());
            if (docProperty.getRequited() != null && docProperty.getRequited().booleanValue()) {
                paramRequireMap.put(docProperty.getName(), docProperty);
            }
            apiProperties.addAll(docProperty.param(property, paramRequireMap));
        }
        return apiProperties;
    }

    public String paramJson(Map<String, DocProperty> paramRequireMap) {
        if (StringUtils.isNotBlank((CharSequence)this.form) && "form-data".equals(this.form)) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)this.type) && !this.type.contains("[0]")) {
            return this.type;
        }
        StringBuilder builder = new StringBuilder();
        String tab = "";
        if (StringUtils.isNotBlank((CharSequence)this.type) && this.type.contains("[0]")) {
            tab = "    ";
            builder.append("[").append("\r\n");
        }
        builder.append(tab).append("{");
        Iterator<DocProperty> it = this.apiProperties.iterator();
        while (it.hasNext()) {
            DocProperty docProperty = it.next();
            String json = docProperty.getJson(null, new StringBuilder("    ").append(tab), true, false, paramRequireMap);
            if (!(json.startsWith("[") || json.contains("{") || it.hasNext())) {
                json = json.replaceFirst("\\,", "");
            }
            builder.append(tab).append("    ").append(json);
            if (!json.endsWith("}") && !json.endsWith("]") || !it.hasNext()) continue;
            builder.append(",");
        }
        builder.append("\r\n").append(tab).append("}");
        if (StringUtils.isNotBlank((CharSequence)this.type) && this.type.contains("[0]")) {
            builder.append("\r\n").append("]");
        }
        return builder.toString();
    }

    public String paramExample() {
        if (StringUtils.isNotBlank((CharSequence)this.form) && "form-data".equals(this.form)) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)this.type) && !this.type.contains("[0]")) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String tab = "";
        if (StringUtils.isNotBlank((CharSequence)this.type) && this.type.contains("[0]")) {
            tab = "    ";
            builder.append("[").append("\r\n");
        }
        builder.append(tab).append("{");
        Iterator<DocProperty> it = this.apiProperties.iterator();
        while (it.hasNext()) {
            DocProperty docProperty = it.next();
            String json = docProperty.getJson(null, new StringBuilder("    ").append(tab), true, true, null);
            if (!(json.startsWith("[") || json.contains("{") || it.hasNext())) {
                json = json.replaceFirst("\\,", "");
            }
            builder.append(tab).append("    ").append(json);
            if (!json.endsWith("}") && !json.endsWith("]") || !it.hasNext()) continue;
            builder.append(",");
        }
        builder.append("\r\n").append(tab).append("}");
        if (StringUtils.isNotBlank((CharSequence)this.type) && this.type.contains("[0]")) {
            builder.append("\r\n").append("]");
        }
        return builder.toString();
    }

    public String returnJson() {
        if (StringUtils.isNotBlank((CharSequence)this.type) && !this.type.contains("[0]")) {
            String json = this.apiProperties.iterator().next().getJson(null, new StringBuilder(), false, false, null);
            return json.substring(json.indexOf("//") + 2);
        }
        StringBuilder builder = new StringBuilder();
        String tab = "";
        if (StringUtils.isNotBlank((CharSequence)this.type) && this.type.contains("[0]")) {
            tab = "    ";
            builder.append("[").append("\r\n");
        }
        builder.append(tab).append("{");
        Iterator<DocProperty> it = this.apiProperties.iterator();
        while (it.hasNext()) {
            DocProperty docProperty = it.next();
            String json = docProperty.getJson(null, new StringBuilder("    ").append(tab), false, false, null);
            if (!(json.startsWith("[") || json.contains("{") || it.hasNext())) {
                json = json.replaceFirst("\\,", "");
            }
            builder.append(tab).append("    ").append(json);
            if (!json.endsWith("}") && !json.endsWith("]") || !it.hasNext()) continue;
            builder.append(",");
        }
        builder.append("\r\n").append(tab).append("}");
        if (StringUtils.isNotBlank((CharSequence)this.type) && this.type.contains("[0]")) {
            builder.append("\r\n").append("]");
        }
        return builder.toString();
    }

    public void android(Set<String> strings) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.className)) {
            if (StringUtils.isNotBlank((CharSequence)this.description)) {
                builder.append("/**\r\n * ").append(this.description).append("\r\n */\r\n");
            }
            builder.append("@Accessors(chain = true)\r\n").append("@Data\r\n");
            builder.append("public class ").append(this.className).append(" {");
        }
        for (DocProperty docProperty : this.apiProperties) {
            String android = docProperty.android(strings);
            builder.append(android);
        }
        if (StringUtils.isNotBlank((CharSequence)this.className) && builder.length() > 0) {
            builder.append("\r\n}\r\n\r\n");
        }
        strings.add(builder.toString());
    }

    public void ios(Set<String> strings) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.className)) {
            if (StringUtils.isNotBlank((CharSequence)this.description)) {
                builder.append("/**\r\n * ").append(this.description).append("\r\n */\r\n");
            }
            builder.append("class ").append(this.className).append(" {");
        }
        for (DocProperty docProperty : this.apiProperties) {
            String android = docProperty.ios(strings);
            builder.append(android);
        }
        if (StringUtils.isNotBlank((CharSequence)this.className) && builder.length() > 0) {
            builder.append("\r\n}\r\n\r\n");
        }
        strings.add(builder.toString());
    }

    public void paramVue(Map<String, Map<String, String>> mapList) {
        if (StringUtils.isBlank((CharSequence)this.className)) {
            if (mapList.isEmpty()) {
                this.className = "Class0";
            }
            for (int i = 0; i < mapList.size(); ++i) {
                if (mapList.containsKey("Class" + i)) continue;
                this.className = "Class" + i;
                break;
            }
        }
        StringBuilder htmlBuilder = new StringBuilder();
        StringBuilder rulesBuilder = new StringBuilder();
        rulesBuilder.append("export default {").append("\r\n  ").append("name: \"").append(StringUtils.capitalize((String)this.className)).append("Vue\",").append("\r\n  ").append("data() {").append("\r\n    ").append("return {").append("\r\n      ");
        rulesBuilder.append(StringUtils.uncapitalize((String)this.className)).append(": {},").append("\r\n      ");
        rulesBuilder.append("visible: false,").append("\r\n      ");
        htmlBuilder.append("<el-dialog title=\"").append("\u65b0\u589e");
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            htmlBuilder.append(this.description);
        }
        htmlBuilder.append("\" center :visible.sync=\"visible\" width=\"30%\">").append("\r\n");
        htmlBuilder.append("    ").append("<el-form :model=\"").append(StringUtils.uncapitalize((String)this.className)).append("\" :rules=\"rules\" ref=\"").append(StringUtils.uncapitalize((String)this.className)).append("\" ").append("\r\n");
        htmlBuilder.append("              ").append("label-width=\"100px\" @keyup.enter.native=\"save").append(this.className).append("()\">").append("\r\n");
        rulesBuilder.append("rules: {").append("\r\n");
        for (DocProperty docProperty : this.apiProperties) {
            docProperty.paramVue(rulesBuilder, htmlBuilder, StringUtils.uncapitalize((String)this.className), mapList);
        }
        rulesBuilder.delete(rulesBuilder.length() - 3, rulesBuilder.length() - 2);
        htmlBuilder.append("    ").append("</el-form>").append("\r\n");
        htmlBuilder.append("    ").append("<span slot=\"footer\" class=\"dialog-footer\">").append("\r\n");
        htmlBuilder.append("        ").append("<el-button type=\"primary\" @click=\"save").append(this.className).append("()\" size=\"mini\">\u63d0 \u4ea4</el-button>").append("\r\n");
        htmlBuilder.append("    ").append("</span>").append("\r\n");
        htmlBuilder.append("</el-dialog>").append("\r\n").append("\r\n");
        rulesBuilder.append("      }").append("\r\n    ");
        rulesBuilder.append("}").append("\r\n  ");
        rulesBuilder.append("},").append("\r\n  ");
        rulesBuilder.append("methods: {").append("\r\n      ");
        rulesBuilder.append("save").append(this.className).append("() {").append("\r\n      ");
        rulesBuilder.append("}").append("\r\n  ");
        rulesBuilder.append("}").append("\r\n");
        rulesBuilder.append("}").append("\r\n");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("HTML", htmlBuilder.toString());
        map.put("JavaScript", rulesBuilder.toString());
        mapList.put(StringUtils.capitalize((String)this.className), map);
    }

    public void returnVue(Map<String, Map<String, String>> mapList) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.className)) {
            if (mapList.isEmpty()) {
                this.className = "Class0";
            }
            for (int i = 0; i < mapList.size(); ++i) {
                if (mapList.containsKey("Class" + i)) continue;
                this.className = "Class" + i;
                break;
            }
        }
        builder.append("<el-table size=\"mini\" :data=\"").append(StringUtils.uncapitalize((String)this.className)).append("s\">").append("\r\n");
        for (DocProperty docProperty : this.apiProperties) {
            docProperty.returnVue(builder, StringUtils.uncapitalize((String)this.className), mapList);
        }
        builder.append("</el-table>").append("\r\n");
        builder.append("<el-pagination").append("\r\n");
        builder.append("    ").append("background").append("\r\n");
        builder.append("    ").append(":current-page=\"page.current*1\"").append("\r\n");
        builder.append("    ").append(":page-sizes=\"[10, 20, 50,100]\"").append("\r\n");
        builder.append("    ").append("layout=\"->,sizes,total,prev, pager, next,jumper\"").append("\r\n");
        builder.append("    ").append("@current-change=\"function(v) {").append("\r\n");
        builder.append("          ").append("page.current = v").append("\r\n");
        builder.append("          ").append("query").append(this.className).append("s();").append("\r\n");
        builder.append("        ").append("}\"").append("\r\n");
        builder.append("    ").append("@size-change=\"function(v) {").append("\r\n");
        builder.append("          ").append("page.size = v").append("\r\n");
        builder.append("          ").append("query").append(this.className).append("s();").append("\r\n");
        builder.append("        ").append("}\"").append("\r\n");
        builder.append("    ").append(":total=\"page.total*1\">").append("\r\n");
        builder.append("</el-pagination>").append("\r\n");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("HTML", builder.toString());
        String rulesBuilder = "export default {\r\n  name: \"" + StringUtils.capitalize((String)this.className) + "Vue\",\r\n  data() {\r\n    return {\r\n      " + StringUtils.uncapitalize((String)this.className) + "s: [],\r\n      page: {}\r\n    }\r\n  },\r\n  methods: {\r\n      query" + this.className + "s() {\r\n      }\r\n  }\r\n}\r\n";
        map.put("JavaScript", rulesBuilder);
        mapList.put(StringUtils.capitalize((String)this.className), map);
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<DocProperty> getApiProperties() {
        return this.apiProperties;
    }

    public String getForm() {
        return this.form;
    }

    public DocModel setDescription(String description) {
        this.description = description;
        return this;
    }

    public DocModel setType(String type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public DocModel setClassName(String className) {
        this.className = className;
        return this;
    }

    public DocModel setApiProperties(Set<DocProperty> apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public DocModel setForm(String form) {
        this.form = form;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocModel)) {
            return false;
        }
        DocModel other = (DocModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Set<DocProperty> this$apiProperties = this.getApiProperties();
        Set<DocProperty> other$apiProperties = other.getApiProperties();
        if (this$apiProperties == null ? other$apiProperties != null : !((Object)this$apiProperties).equals(other$apiProperties)) {
            return false;
        }
        String this$form = this.getForm();
        String other$form = other.getForm();
        return !(this$form == null ? other$form != null : !this$form.equals(other$form));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Set<DocProperty> $apiProperties = this.getApiProperties();
        result = result * 59 + ($apiProperties == null ? 43 : ((Object)$apiProperties).hashCode());
        String $form = this.getForm();
        result = result * 59 + ($form == null ? 43 : $form.hashCode());
        return result;
    }

    public String toString() {
        return "DocModel(description=" + this.getDescription() + ", type=" + this.getType() + ", className=" + this.getClassName() + ", apiProperties=" + this.getApiProperties() + ", form=" + this.getForm() + ")";
    }
}

