/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final String TIMESTAMP = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";
    public static final String YEAR = "yyyy";
    public static final String MONTH = "MM";
    public static final String DAY = "dd";
    public static final String WEEKDAY = "E";
    public static final String[] PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static String getDateString(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String getYear(Date date) {
        return DateUtils.getDateString(date, YEAR);
    }

    public static String getMonth(Date date) {
        return DateUtils.getDateString(date, MONTH);
    }

    public static String getDay(Date date) {
        return DateUtils.getDateString(date, DAY);
    }

    public static String getWeek(Date date) {
        return DateUtils.getDateString(date, WEEKDAY);
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])PATTERNS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date currentDate, Date pastDate) {
        long t = currentDate.getTime() - pastDate.getTime();
        return t / 86400000L;
    }

    public static long pastHours(Date currentDate, Date pastDate) {
        long t = currentDate.getTime() - pastDate.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date currentDate, Date pastDate) {
        long t = currentDate.getTime() - pastDate.getTime();
        return t / 60000L;
    }

    public static String formatTime(long time, String format) {
        Date date = new Date(time);
        return DateUtils.getDateString(date, format);
    }

    public static Date getAssignDay(Date time, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(5, offset);
        return calendar.getTime();
    }

    public static Date getBeginDay(Date time) {
        String dateStr = DateUtils.getDateString(time, DATE).concat(" 00:00:00");
        try {
            return DateUtils.parseDate((String)dateStr, (String[])new String[]{DATETIME});
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getEndDay(Date time) {
        String dateStr = DateUtils.getDateString(time, DATE).concat(" 23:59:59");
        try {
            return DateUtils.parseDate((String)dateStr, (String[])new String[]{DATETIME});
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getMonday(Date currentDate) {
        Calendar can = Calendar.getInstance(Locale.CHINA);
        if (currentDate != null) {
            can.setTime(currentDate);
        }
        can.set(7, 2);
        return can.getTime();
    }
}

