/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class EncodesUtils {
    public static final String DEFAULT_ENCODE = "UTF-8";
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) throws DecoderException {
        return Hex.decodeHex((char[])input.toCharArray());
    }

    public static String encodeBase64(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String encodeBase64(String input) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])input.getBytes(DEFAULT_ENCODE)));
    }

    public static byte[] decodeBase64(String input) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])input.getBytes(DEFAULT_ENCODE));
    }

    public static String decodeBase64String(String input) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((byte[])input.getBytes(DEFAULT_ENCODE)), DEFAULT_ENCODE);
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        int i = 0;
        while (i < input.length) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
            ++i;
        }
        return new String(chars);
    }

    public static String urlEncode(String part) throws UnsupportedEncodingException {
        return URLEncoder.encode(part, DEFAULT_ENCODE);
    }

    public static String urlDecode(String part) throws UnsupportedEncodingException {
        return URLDecoder.decode(part, DEFAULT_ENCODE);
    }
}

