/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import com.alibaba.fastjson.JSON;
import com.ckjava.utils.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static int timeout = 100000;

    public static String put(String url, Object obj) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http put:" + url);
            HttpPut put = HttpClientUtils.putForm(url, obj);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)put);
            return string;
        }
        catch (Exception e) {
            log.error("http put has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String put(String url, Map<String, String> headers, Map<String, String> parameters, Object obj) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http put:" + url);
            HttpPut put = HttpClientUtils.putJSONForm(url, headers, parameters, obj);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)put);
            return string;
        }
        catch (Exception e) {
            log.error("http put has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String post(String url, Object obj) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http post:" + url);
            HttpPost post = HttpClientUtils.postJSONForm(url, null, null, obj);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)post);
            return string;
        }
        catch (Exception e) {
            log.error("http post has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String post(String url, Map<String, String> headers, Map<String, String> parameters, Object obj) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http post:" + url);
            HttpPost post = HttpClientUtils.postJSONForm(url, headers, parameters, obj);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)post);
            return string;
        }
        catch (Exception e) {
            log.error("http post has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String postUrlEncodeForm(String url, Map<String, String> headers, Map<String, String> parameters, List<NameValuePair> formParams) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http post:" + url);
            HttpPost httpPost = HttpClientUtils.postEncodeForm(url, headers, parameters, formParams);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)httpPost);
            return string;
        }
        catch (Exception e) {
            log.error("http post has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String get(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClientUtils.initWeakSSLClient();
        try {
            url = HttpClientUtils.appendRequestParameter(url, params);
            log.info("create http get:" + url);
            HttpGet httpGet = new HttpGet(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> data : headers.entrySet()) {
                    String key = data.getKey();
                    String value = data.getValue();
                    httpGet.addHeader(key, value);
                }
            }
            String string = HttpClientUtils.invoke(httpClient, (HttpUriRequest)httpGet);
            return string;
        }
        catch (Exception e) {
            log.error("http get has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String delete(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClientUtils.initWeakSSLClient();
        try {
            url = HttpClientUtils.appendRequestParameter(url, params);
            log.info("create http delete:" + url);
            HttpDelete httpDelete = new HttpDelete(url);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> data : headers.entrySet()) {
                    String key = data.getKey();
                    String value = data.getValue();
                    httpDelete.addHeader(key, value);
                }
            }
            String string = HttpClientUtils.invoke(httpClient, (HttpUriRequest)httpDelete);
            return string;
        }
        catch (Exception e) {
            log.error("http delete has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String appendRequestParameter(String url, Map<String, String> params) {
        if (StringUtils.isNotBlank((CharSequence)url) && params != null && !params.isEmpty()) {
            boolean flag = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (flag && url.indexOf("?") == -1) {
                    url = String.valueOf(url) + "?" + entry.getKey() + "=" + entry.getValue();
                    flag = false;
                    continue;
                }
                url = String.valueOf(url) + "&" + entry.getKey() + "=" + entry.getValue();
            }
        }
        return url;
    }

    private static String invoke(CloseableHttpClient httpclient, HttpUriRequest httprequest) {
        HttpResponse response = HttpClientUtils.sendRequest((HttpClient)httpclient, httprequest);
        return HttpClientUtils.paseResponse(response);
    }

    private static String paseResponse(HttpResponse response) {
        log.info("get response from http server..");
        HttpEntity entity = response.getEntity();
        log.info("response status: " + response.getStatusLine());
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            log.error("paseResponse has error", (Throwable)e);
            return null;
        }
    }

    private static HttpResponse sendRequest(HttpClient httpclient, HttpUriRequest request) {
        log.info("execute request...");
        HttpResponse response = null;
        try {
            response = httpclient.execute(request);
        }
        catch (Exception e) {
            log.error("sendRequest has error", (Throwable)e);
        }
        return response;
    }

    private static HttpPost postJSONForm(String url, Map<String, String> headers, Map<String, String> parameters, Object obj) {
        url = HttpClientUtils.appendRequestParameter(url, parameters);
        HttpPost httpost = new HttpPost(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> data : headers.entrySet()) {
                String key = data.getKey();
                String value = data.getValue();
                httpost.addHeader(key, value);
            }
        }
        try {
            StringEntity se = new StringEntity(JSON.toJSONString((Object)obj), "UTF-8");
            se.setContentType("application/json");
            se.setContentEncoding("UTF-8");
            httpost.setEntity((HttpEntity)se);
        }
        catch (Exception e) {
            log.error("postJSONForm has Exception", (Throwable)e);
        }
        return httpost;
    }

    private static HttpPost postEncodeForm(String url, Map<String, String> headers, Map<String, String> parameters, List<NameValuePair> formParams) {
        url = HttpClientUtils.appendRequestParameter(url, parameters);
        HttpPost httpPost = new HttpPost(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> data : headers.entrySet()) {
                String key = data.getKey();
                String value = data.getValue();
                httpPost.addHeader(key, value);
            }
        }
        try {
            if (formParams != null && !formParams.isEmpty()) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, "UTF-8");
                httpPost.setEntity((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error("postEncodeForm has error", (Throwable)e);
        }
        return httpPost;
    }

    private static HttpPut putJSONForm(String url, Map<String, String> headers, Map<String, String> parameters, Object obj) {
        url = HttpClientUtils.appendRequestParameter(url, parameters);
        HttpPut httput = new HttpPut(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> data : headers.entrySet()) {
                String key = data.getKey();
                String value = data.getValue();
                httput.addHeader(key, value);
            }
        }
        try {
            httput.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)obj)));
        }
        catch (UnsupportedEncodingException e) {
            log.error("postForm has UnsupportedEncodingException", (Throwable)e);
        }
        return httput;
    }

    private static HttpPut putForm(String url, Object obj) {
        HttpPut httput = new HttpPut(url);
        httput.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; QQDownload 1.7; .NET CLR 1.1.4322; CIBA; .NET CLR 2.0.50727)");
        try {
            StringEntity se = new StringEntity(JSON.toJSONString((Object)obj), "UTF-8");
            se.setContentType("application/json");
            se.setContentEncoding("UTF-8");
            log.info("set utf-8 form entity to httput");
            httput.setEntity((HttpEntity)se);
        }
        catch (Exception e) {
            log.error("UnsupportedEncodingException...");
        }
        return httput;
    }

    private static CloseableHttpClient initWeakSSLClient() {
        HttpClientBuilder b = HttpClientBuilder.create();
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        b.setSslcontext(sslContext);
        X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        b.setConnectionManager((HttpClientConnectionManager)connMgr);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(timeout);
        configBuilder.setSocketTimeout(timeout);
        b.setDefaultRequestConfig(configBuilder.build());
        CloseableHttpClient sslClient = b.build();
        return sslClient;
    }

    public static void main(String[] args) {
    }
}

