/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import com.ckjava.utils.ArrayUtils;
import com.ckjava.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtils
extends org.apache.commons.lang3.ObjectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtils.class);

    public static boolean isEmptyObject(Object obj) {
        Field[] fields;
        if (obj == null || obj.toString().equals("")) {
            return true;
        }
        Field[] fieldArray = fields = obj.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                boolean flag = field.isAccessible();
                boolean isStatic = Modifier.toString(field.getModifiers()).contains("static");
                if (!isStatic) {
                    Object fieldObj;
                    if (!flag) {
                        field.setAccessible(true);
                    }
                    if ((fieldObj = field.get(obj)) != null && !fieldObj.toString().equals("")) {
                        return false;
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNotEmptyObject(Object obj) {
        Field[] fields;
        if (obj == null || obj.toString().equals("")) {
            return false;
        }
        Field[] fieldArray = fields = obj.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                boolean flag = field.isAccessible();
                boolean isStatic = Modifier.toString(field.getModifiers()).contains("static");
                if (!isStatic) {
                    Object fieldObj;
                    if (!flag) {
                        field.setAccessible(true);
                    }
                    if ((fieldObj = field.get(obj)) == null || fieldObj.toString().equals("")) {
                        return false;
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return true;
    }

    public static String getObjectString(Object obj) {
        if (obj == null || obj.toString().equals("")) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        StringBuilder data = new StringBuilder();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                boolean flag = field.isAccessible();
                boolean isStatic = Modifier.toString(field.getModifiers()).contains("static");
                if (!isStatic) {
                    Object fieldObj;
                    Class<?> clazz;
                    if (!flag) {
                        field.setAccessible(true);
                    }
                    if (!(clazz = field.getType()).equals(obj.getClass()) && (fieldObj = field.get(obj)) != null && !fieldObj.toString().equals("")) {
                        data.append(field.getName()).append("=").append(String.valueOf(fieldObj)).append("&");
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return data.toString();
    }

    public static Map<String, Object> fillMapWithString(String data) {
        String[] datas;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)data)) {
            return dataMap;
        }
        String[] stringArray = datas = data.split("&");
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String[] keyValue = str.split("=");
            dataMap.put(ArrayUtils.getValue(keyValue, 0), ArrayUtils.getValue(keyValue, 1));
            ++n2;
        }
        return dataMap;
    }

    public static byte[] objectToBytes(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("ObjectUtils.objectToBytes has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                oos.close();
                baos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Object bytesToObject(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            logger.error("ObjectUtils.bytesToObject has error", (Throwable)e);
            return null;
        }
        finally {
            try {
                ois.close();
                bais.close();
            }
            catch (Exception exception) {}
        }
    }
}

