/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class XmlUtils {
    public static <T> T xml2Obj(String xml, Class<T> clazz) throws JAXBException {
        JAXBContext requestContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = requestContext.createUnmarshaller();
        StringReader sr = new StringReader(xml);
        return (T)unmarshaller.unmarshal((Reader)sr);
    }

    public static String convertNode2XmlString(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(new DOMSource(node), result);
        return writer.toString();
    }

    public static String obj2Xml(Object obj, Map<String, Object> marshallerProperties) throws JAXBException {
        JAXBContext responseContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = responseContext.createMarshaller();
        if (marshallerProperties != null && !marshallerProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : marshallerProperties.entrySet()) {
                marshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        StringWriter sw = new StringWriter();
        marshaller.marshal(obj, (Writer)sw);
        return sw.toString();
    }

    public static Node appendObj2Node(Object obj, Node node) throws JAXBException {
        JAXBContext responseContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = responseContext.createMarshaller();
        marshaller.marshal(obj, node);
        return node;
    }
}

