package com.ckjava.db.utils;


import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.tomcat.jdbc.pool.PoolProperties;

import com.ckjava.utils.StringUtils;

/**
 * 数据库相关的帮助类
 * 
 * <ul>
 * <li>根据 dburl,username,password 获取数据源 {@code DataSource } </li>
 * <li>根据 数据源 可以获取到数据库的 所有表 的列表</li>
 * <li>根据 数据源 和 表名 获取到表的详细信息</li>
 * <li>根据 数据源 和 sql 获取到查询结果</li>
 * <li>根据 数据源 和 sql 获取到查询结果,并且带有列名</li>
 * <li></li>
 * <li></li>
 * </ul>
 * 
 * @author chen_k
 *
 * 2018年1月31日-下午7:22:54
 */
public class DbUtils extends StringUtils {
	
	private static Map<String, DataSource> dataSourceMap = Collections.synchronizedMap(new HashMap<String, DataSource>());
	
	/**
	 * 根据 db url, 用户名, 密码创建数据源, 并将其存入到类缓存中, 自动根据 url 中的定义加载驱动类
	 * 
	 * @param url 数据库连接 url, 包含数据库主机名,端口号,数据库
	 * @param username 数据库用户名
	 * @param password 数据库密码
	 * @return {@code DataSource}
	 * @throws Exception 异常对象
	 */
	public static DataSource createDataSource(String url, String username, String password) throws Exception {
		String dbKey = getDbKey(url, username, password);
		DataSource ds = dataSourceMap.get(dbKey);
		if (ds == null) {
			DatabasePoolConfig poolConfig = new DatabasePoolConfig();
			
			PoolProperties p = poolConfig.getPoolProperties();
			p.setUrl(url);
	        p.setUsername(username);
	        p.setPassword(password);
	        
	        if (url.contains("jdbc:mysql")) {
	        	p.setDriverClassName("com.mysql.jdbc.Driver");
	        } else if (url.contains("jdbc:sqlserver")) {
	        	p.setDriverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
	        } else {
	        	throw new RuntimeException(MessageFormat.format("can't load DriverClass by url:{0}", url));
	        }
			
	        org.apache.tomcat.jdbc.pool.DataSource newDS = new org.apache.tomcat.jdbc.pool.DataSource(p);
	        
	        dataSourceMap.put(dbKey, newDS);
	        
			return newDS;	
		} else {
			return ds;
		}
	}
	
	private static String getDbKey(String url, String username, String password) {
		StringBuilder str = new StringBuilder();
		str.append(url).append(AT_CONCAT).append(username).append(AT_CONCAT).append(password);
		return str.toString();
	}

}
