/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import com.ckjava.utils.Constants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class EncodesUtils
implements Constants {
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) throws DecoderException {
        return Hex.decodeHex((char[])input.toCharArray());
    }

    public static String encodeBase64(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String encodeBase64(String input) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])input.getBytes("UTF-8")));
    }

    public static byte[] decodeBase64(String input) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])input.getBytes("UTF-8"));
    }

    public static String decodeBase64String(String input) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((byte[])input.getBytes("UTF-8")), "UTF-8");
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
        }
        return new String(chars);
    }

    public static String urlEncode(String part) throws UnsupportedEncodingException {
        return URLEncoder.encode(part, "UTF-8");
    }

    public static String urlDecode(String part) throws UnsupportedEncodingException {
        return URLDecoder.decode(part, "UTF-8");
    }
}

