/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.utils;

import com.ckjava.utils.ArrayUtils;
import com.ckjava.utils.Constants;
import com.ckjava.utils.EncodesUtils;
import com.ckjava.utils.IOUtils;
import com.ckjava.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils
extends org.apache.commons.io.FileUtils
implements Constants {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static boolean copyFile(String srcFileName, String descFileName) {
        return FileUtils.copyFileCover(srcFileName, descFileName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileCover(String srcFileName, String descFileName, boolean coverlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 " + srcFileName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcFile.isFile()) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c" + srcFileName + " \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6!");
            return false;
        }
        File descFile = new File(descFileName);
        if (descFile.exists()) {
            if (!coverlay) {
                logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtils.delFile(descFileName)) {
                logger.debug("\u5220\u9664\u76ee\u6807\u6587\u4ef6 " + descFileName + " \u5931\u8d25!");
                return false;
            }
        } else if (!descFile.getParentFile().exists()) {
            logger.debug("\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u76ee\u5f55!");
            if (!descFile.getParentFile().mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        int readByte = 0;
        FileInputStream ins = null;
        OutputStream outs = null;
        try {
            ins = new FileInputStream(srcFile);
            outs = new FileOutputStream(descFile);
            byte[] buf = new byte[1024];
            while (true) {
                if ((readByte = ((InputStream)ins).read(buf)) == -1) {
                    logger.debug("\u590d\u5236\u5355\u4e2a\u6587\u4ef6 " + srcFileName + " \u5230" + descFileName + "\u6210\u529f!");
                    return true;
                }
                outs.write(buf, 0, readByte);
            }
        }
        catch (Exception e) {
            logger.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        finally {
            if (outs != null) {
                try {
                    outs.close();
                }
                catch (IOException oute) {
                    oute.printStackTrace();
                }
            }
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ine) {
                    ine.printStackTrace();
                }
            }
        }
    }

    public static boolean copyDirectory(String srcDirName, String descDirName) {
        return FileUtils.copyDirectoryCover(srcDirName, descDirName, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean copyDirectoryCover(String srcDirName, String descDirName, boolean coverlay) {
        File descDir;
        File srcDir = new File(srcDirName);
        if (!srcDir.exists()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c\u6e90\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return false;
        }
        if (!srcDir.isDirectory()) {
            logger.debug("\u590d\u5236\u76ee\u5f55\u5931\u8d25\uff0c" + srcDirName + " \u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55!");
            return false;
        }
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = String.valueOf(descDirNames) + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            if (!coverlay) {
                logger.debug("\u76ee\u6807\u76ee\u5f55\u590d\u5236\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
                return false;
            }
            logger.debug("\u76ee\u6807\u76ee\u5f55\u5df2\u5b58\u5728\uff0c\u51c6\u5907\u5220\u9664!");
            if (!FileUtils.delFile(descDirNames)) {
                logger.debug("\u5220\u9664\u76ee\u5f55 " + descDirNames + " \u5931\u8d25!");
                return false;
            }
        } else {
            logger.debug("\u76ee\u6807\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa!");
            if (!descDir.mkdirs()) {
                logger.debug("\u521b\u5efa\u76ee\u6807\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
        }
        boolean flag = true;
        File[] files = srcDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && !(flag = FileUtils.copyFile(files[i].getAbsolutePath(), String.valueOf(descDirName) + files[i].getName())) || files[i].isDirectory() && !(flag = FileUtils.copyDirectory(files[i].getAbsolutePath(), String.valueOf(descDirName) + files[i].getName()))) break;
            ++i;
        }
        if (!flag) {
            logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u5931\u8d25!");
            return false;
        }
        logger.debug("\u590d\u5236\u76ee\u5f55 " + srcDirName + " \u5230 " + descDirName + " \u6210\u529f!");
        return true;
    }

    public static boolean delFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            logger.debug(String.valueOf(fileName) + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
            return true;
        }
        if (file.isFile()) {
            return FileUtils.deleteFile(fileName);
        }
        return FileUtils.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u6210\u529f!");
                return true;
            }
            logger.debug("\u5220\u9664\u6587\u4ef6 " + fileName + " \u5931\u8d25!");
            return false;
        }
        logger.debug(String.valueOf(fileName) + " \u6587\u4ef6\u4e0d\u5b58\u5728!");
        return true;
    }

    public static boolean deleteDirectory(String dirName) {
        File dirFile;
        String dirNames = dirName;
        if (!dirNames.endsWith(File.separator)) {
            dirNames = String.valueOf(dirNames) + File.separator;
        }
        if (!(dirFile = new File(dirNames)).exists() || !dirFile.isDirectory()) {
            logger.debug(String.valueOf(dirNames) + " \u76ee\u5f55\u4e0d\u5b58\u5728!");
            return true;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() ? !(flag = FileUtils.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = FileUtils.deleteDirectory(files[i].getAbsolutePath()))) break;
            ++i;
        }
        if (!flag) {
            logger.debug("\u5220\u9664\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        if (dirFile.delete()) {
            logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u6210\u529f!");
            return true;
        }
        logger.debug("\u5220\u9664\u76ee\u5f55 " + dirName + " \u5931\u8d25!");
        return false;
    }

    public static boolean createFile(String descFileName) {
        block6: {
            File file = new File(descFileName);
            if (file.exists()) {
                logger.debug("\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!");
                return false;
            }
            if (descFileName.endsWith(File.separator)) {
                logger.debug(String.valueOf(descFileName) + " \u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55!");
                return false;
            }
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                logger.debug("\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
                return false;
            }
            try {
                if (!file.createNewFile()) break block6;
                logger.debug(String.valueOf(descFileName) + " \u6587\u4ef6\u521b\u5efa\u6210\u529f!");
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug(String.valueOf(descFileName) + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
                return false;
            }
        }
        logger.debug(String.valueOf(descFileName) + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!");
        return false;
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = String.valueOf(descDirNames) + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!");
            return false;
        }
        if (descDir.mkdirs()) {
            logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u6210\u529f!");
            return true;
        }
        logger.debug("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u5931\u8d25!");
        return false;
    }

    public static void writeToFile(String fileName, String content, boolean append) {
        try {
            FileUtils.write((File)new File(fileName), (CharSequence)content, (String)"UTF-8", (boolean)append);
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!");
        }
        catch (IOException e) {
            logger.debug("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage());
        }
    }

    public static void zipFiles(String srcDirName, String fileName, String[] excludePath, String[] excludeFile, File descFile) {
        if (srcDirName == null) {
            logger.debug("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff0c\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return;
        }
        File fileDir = new File(srcDirName);
        if (!fileDir.exists() || !fileDir.isDirectory()) {
            logger.debug("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff0c\u76ee\u5f55 " + srcDirName + " \u4e0d\u5b58\u5728!");
            return;
        }
        String dirPath = fileDir.getAbsolutePath();
        try {
            ZipOutputStream zouts = new ZipOutputStream(new FileOutputStream(descFile));
            if ("*".equals(fileName) || "".equals(fileName)) {
                FileUtils.zipDirectoryToZipFile(dirPath, fileDir, excludePath, excludeFile, zouts);
            } else {
                File file = new File(fileDir, fileName);
                if (file.isFile()) {
                    FileUtils.zipFilesToZipFile(dirPath, file, zouts);
                } else {
                    FileUtils.zipDirectoryToZipFile(dirPath, file, excludePath, excludeFile, zouts);
                }
            }
            zouts.close();
            logger.debug(String.valueOf(descFile.getName()) + " \u6587\u4ef6\u538b\u7f29\u6210\u529f!");
        }
        catch (Exception e) {
            logger.debug("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static File zipFile(File file) {
        if (file.exists()) {
            String filePath = file.getParent();
            try {
                File zipFile = new File(String.valueOf(filePath) + File.separator + file.getName() + ".zip");
                ZipOutputStream zouts = new ZipOutputStream(new FileOutputStream(zipFile));
                FileUtils.zipFilesToZipFile(filePath, file, zouts);
                zouts.close();
                return zipFile;
            }
            catch (Exception e) {
                logger.error("zip file fail" + e);
                return null;
            }
        }
        throw new RuntimeException("file not exits");
    }

    public static void zipDirectoryToZipFile(String dirPath, File fileDir, String[] excludePath, String[] excludeFile, ZipOutputStream zouts) {
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            if (files.length == 0) {
                ZipEntry entry = new ZipEntry(FileUtils.getEntryName(dirPath, fileDir));
                try {
                    zouts.putNextEntry(entry);
                    zouts.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            int i = 0;
            while (i < files.length) {
                File tempFile = files[i];
                if (tempFile.isFile()) {
                    if (!ArrayUtils.contains((Object[])excludeFile, (Object)tempFile.getName())) {
                        FileUtils.zipFilesToZipFile(dirPath, files[i], zouts);
                    }
                } else if (!ArrayUtils.contains((Object[])excludePath, (Object)tempFile.getName())) {
                    FileUtils.zipDirectoryToZipFile(dirPath, files[i], excludePath, excludeFile, zouts);
                }
                ++i;
            }
        }
    }

    public static void zipFilesToZipFile(String dirPath, File file, ZipOutputStream zouts) {
        FileInputStream fin = null;
        ZipEntry entry = null;
        byte[] buf = new byte[4096];
        int readByte = 0;
        if (file.isFile()) {
            try {
                fin = new FileInputStream(file);
                entry = new ZipEntry(FileUtils.getEntryName(dirPath, file));
                zouts.putNextEntry(entry);
                while ((readByte = fin.read(buf)) != -1) {
                    zouts.write(buf, 0, readByte);
                }
                zouts.closeEntry();
                fin.close();
                System.out.println("\u6dfb\u52a0\u6587\u4ef6 " + file.getAbsolutePath() + " \u5230zip\u6587\u4ef6\u4e2d!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getEntryName(String dirPath, File file) {
        String dirPaths = dirPath;
        if (!dirPaths.endsWith(File.separator)) {
            dirPaths = String.valueOf(dirPaths) + File.separator;
        }
        String filePath = file.getAbsolutePath();
        if (file.isDirectory()) {
            filePath = String.valueOf(filePath) + "/";
        }
        int index = filePath.indexOf(dirPaths);
        return filePath.substring(index + dirPaths.length());
    }

    public static String getContentType(String returnFileName) {
        String contentType = "application/octet-stream";
        if (returnFileName.lastIndexOf(".") < 0) {
            return contentType;
        }
        returnFileName = returnFileName.toLowerCase();
        if ((returnFileName = returnFileName.substring(returnFileName.lastIndexOf(".") + 1)).equals("html") || returnFileName.equals("htm") || returnFileName.equals("shtml")) {
            contentType = "text/html";
        } else if (returnFileName.equals("apk")) {
            contentType = "application/vnd.android.package-archive";
        } else if (returnFileName.equals("sis")) {
            contentType = "application/vnd.symbian.install";
        } else if (returnFileName.equals("sisx")) {
            contentType = "application/vnd.symbian.install";
        } else if (returnFileName.equals("exe")) {
            contentType = "application/x-msdownload";
        } else if (returnFileName.equals("msi")) {
            contentType = "application/x-msdownload";
        } else if (returnFileName.equals("css")) {
            contentType = "text/css";
        } else if (returnFileName.equals("xml")) {
            contentType = "text/xml";
        } else if (returnFileName.equals("gif")) {
            contentType = "image/gif";
        } else if (returnFileName.equals("jpeg") || returnFileName.equals("jpg")) {
            contentType = "image/jpeg";
        } else if (returnFileName.equals("js")) {
            contentType = "application/x-javascript";
        } else if (returnFileName.equals("atom")) {
            contentType = "application/atom+xml";
        } else if (returnFileName.equals("rss")) {
            contentType = "application/rss+xml";
        } else if (returnFileName.equals("mml")) {
            contentType = "text/mathml";
        } else if (returnFileName.equals("txt")) {
            contentType = "text/plain";
        } else if (returnFileName.equals("jad")) {
            contentType = "text/vnd.sun.j2me.app-descriptor";
        } else if (returnFileName.equals("wml")) {
            contentType = "text/vnd.wap.wml";
        } else if (returnFileName.equals("htc")) {
            contentType = "text/x-component";
        } else if (returnFileName.equals("png")) {
            contentType = "image/png";
        } else if (returnFileName.equals("tif") || returnFileName.equals("tiff")) {
            contentType = "image/tiff";
        } else if (returnFileName.equals("wbmp")) {
            contentType = "image/vnd.wap.wbmp";
        } else if (returnFileName.equals("ico")) {
            contentType = "image/x-icon";
        } else if (returnFileName.equals("jng")) {
            contentType = "image/x-jng";
        } else if (returnFileName.equals("bmp")) {
            contentType = "image/x-ms-bmp";
        } else if (returnFileName.equals("svg")) {
            contentType = "image/svg+xml";
        } else if (returnFileName.equals("jar") || returnFileName.equals("var") || returnFileName.equals("ear")) {
            contentType = "application/java-archive";
        } else if (returnFileName.equals("doc")) {
            contentType = "application/msword";
        } else if (returnFileName.equals("pdf")) {
            contentType = "application/pdf";
        } else if (returnFileName.equals("rtf")) {
            contentType = "application/rtf";
        } else if (returnFileName.equals("xls")) {
            contentType = "application/vnd.ms-excel";
        } else if (returnFileName.equals("ppt")) {
            contentType = "application/vnd.ms-powerpoint";
        } else if (returnFileName.equals("7z")) {
            contentType = "application/x-7z-compressed";
        } else if (returnFileName.equals("rar")) {
            contentType = "application/x-rar-compressed";
        } else if (returnFileName.equals("swf")) {
            contentType = "application/x-shockwave-flash";
        } else if (returnFileName.equals("rpm")) {
            contentType = "application/x-redhat-package-manager";
        } else if (returnFileName.equals("der") || returnFileName.equals("pem") || returnFileName.equals("crt")) {
            contentType = "application/x-x509-ca-cert";
        } else if (returnFileName.equals("xhtml")) {
            contentType = "application/xhtml+xml";
        } else if (returnFileName.equals("zip")) {
            contentType = "application/zip";
        } else if (returnFileName.equals("mid") || returnFileName.equals("midi") || returnFileName.equals("kar")) {
            contentType = "audio/midi";
        } else if (returnFileName.equals("mp3")) {
            contentType = "audio/mpeg";
        } else if (returnFileName.equals("ogg")) {
            contentType = "audio/ogg";
        } else if (returnFileName.equals("m4a")) {
            contentType = "audio/x-m4a";
        } else if (returnFileName.equals("ra")) {
            contentType = "audio/x-realaudio";
        } else if (returnFileName.equals("3gpp") || returnFileName.equals("3gp")) {
            contentType = "video/3gpp";
        } else if (returnFileName.equals("mp4")) {
            contentType = "video/mp4";
        } else if (returnFileName.equals("mpeg") || returnFileName.equals("mpg")) {
            contentType = "video/mpeg";
        } else if (returnFileName.equals("mov")) {
            contentType = "video/quicktime";
        } else if (returnFileName.equals("flv")) {
            contentType = "video/x-flv";
        } else if (returnFileName.equals("m4v")) {
            contentType = "video/x-m4v";
        } else if (returnFileName.equals("mng")) {
            contentType = "video/x-mng";
        } else if (returnFileName.equals("asx") || returnFileName.equals("asf")) {
            contentType = "video/x-ms-asf";
        } else if (returnFileName.equals("wmv")) {
            contentType = "video/x-ms-wmv";
        } else if (returnFileName.equals("avi")) {
            contentType = "video/x-msvideo";
        }
        return contentType;
    }

    public static String downFile(File file, HttpServletRequest request, HttpServletResponse response) {
        return FileUtils.downFile(file, request, response, null);
    }

    public static String downFile(File file, HttpServletRequest request, HttpServletResponse response, String fileName) {
        block45: {
            String error = null;
            if (file != null && file.exists()) {
                if (file.isFile()) {
                    if (file.length() <= 0L) {
                        error = "\u8be5\u6587\u4ef6\u662f\u4e00\u4e2a\u7a7a\u6587\u4ef6\u3002";
                    }
                    if (!file.canRead()) {
                        error = "\u8be5\u6587\u4ef6\u6ca1\u6709\u8bfb\u53d6\u6743\u9650\u3002";
                    }
                } else {
                    error = "\u8be5\u6587\u4ef6\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\u3002";
                }
            } else {
                error = "\u6587\u4ef6\u5df2\u4e22\u5931\u6216\u4e0d\u5b58\u5728\uff01";
            }
            if (error != null) {
                logger.debug("---------------" + file + " " + error);
                return error;
            }
            long fileLength = file.length();
            long pastLength = 0L;
            int rangeSwitch = 0;
            long toLength = 0L;
            long contentLength = 0L;
            String rangeBytes = "";
            RandomAccessFile raf = null;
            ServletOutputStream os = null;
            OutputStream out = null;
            byte[] b = new byte[1024];
            if (request.getHeader("Range") != null) {
                response.setStatus(206);
                logger.debug("request.getHeader(\"Range\") = " + request.getHeader("Range"));
                rangeBytes = request.getHeader("Range").replaceAll("bytes=", "");
                if (rangeBytes.indexOf(45) == rangeBytes.length() - 1) {
                    rangeSwitch = 1;
                    rangeBytes = rangeBytes.substring(0, rangeBytes.indexOf(45));
                    pastLength = Long.parseLong(rangeBytes.trim());
                    contentLength = fileLength - pastLength;
                } else {
                    rangeSwitch = 2;
                    String temp0 = rangeBytes.substring(0, rangeBytes.indexOf(45));
                    String temp2 = rangeBytes.substring(rangeBytes.indexOf(45) + 1, rangeBytes.length());
                    pastLength = Long.parseLong(temp0.trim());
                    toLength = Long.parseLong(temp2);
                    contentLength = toLength - pastLength;
                }
            } else {
                contentLength = fileLength;
            }
            response.reset();
            if (pastLength != 0L) {
                response.setHeader("Accept-Ranges", "bytes");
                logger.debug("---------------\u4e0d\u662f\u4ece\u5f00\u59cb\u8fdb\u884c\u4e0b\u8f7d\uff01\u670d\u52a1\u5668\u5373\u5c06\u5f00\u59cb\u65ad\u70b9\u7eed\u4f20...");
                switch (rangeSwitch) {
                    case 1: {
                        String contentRange = new StringBuffer("bytes ").append(new Long(pastLength).toString()).append("-").append(new Long(fileLength - 1L).toString()).append("/").append(new Long(fileLength).toString()).toString();
                        response.setHeader("Content-Range", contentRange);
                        break;
                    }
                    case 2: {
                        String contentRange = String.valueOf(rangeBytes) + "/" + new Long(fileLength).toString();
                        response.setHeader("Content-Range", contentRange);
                        break;
                    }
                }
            } else {
                logger.debug("---------------\u662f\u4ece\u5f00\u59cb\u8fdb\u884c\u4e0b\u8f7d\uff01");
            }
            try {
                try {
                    response.addHeader("Content-Disposition", "attachment; filename=\"" + EncodesUtils.urlEncode(StringUtils.isBlank((CharSequence)fileName) ? file.getName() : fileName) + "\"");
                    response.setContentType(FileUtils.getContentType(file.getName()));
                    response.addHeader("Content-Length", String.valueOf(contentLength));
                    os = response.getOutputStream();
                    out = new BufferedOutputStream((OutputStream)os);
                    raf = new RandomAccessFile(file, "r");
                    try {
                        switch (rangeSwitch) {
                            case 0: 
                            case 1: {
                                raf.seek(pastLength);
                                int n = 0;
                                while ((n = raf.read(b, 0, 1024)) != -1) {
                                    out.write(b, 0, n);
                                }
                                break;
                            }
                            case 2: {
                                raf.seek(pastLength);
                                int n = 0;
                                long readLength = 0L;
                                while (readLength <= contentLength - 1024L) {
                                    n = raf.read(b, 0, 1024);
                                    readLength += 1024L;
                                    out.write(b, 0, n);
                                }
                                if (readLength > contentLength) break;
                                n = raf.read(b, 0, (int)(contentLength - readLength));
                                out.write(b, 0, n);
                                break;
                            }
                        }
                        out.flush();
                        logger.debug("---------------\u4e0b\u8f7d\u5b8c\u6210\uff01");
                    }
                    catch (IOException ie) {
                        logger.debug("\u63d0\u9192\uff1a\u5411\u5ba2\u6237\u7aef\u4f20\u8f93\u65f6\u51fa\u73b0IO\u5f02\u5e38\uff0c\u4f46\u6b64\u5f02\u5e38\u662f\u5141\u8bb8\u7684\uff0c\u6709\u53ef\u80fd\u5ba2\u6237\u7aef\u53d6\u6d88\u4e86\u4e0b\u8f7d\uff0c\u5bfc\u81f4\u6b64\u5f02\u5e38\uff0c\u4e0d\u7528\u5173\u5fc3\uff01");
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            logger.error(e2.getMessage(), (Throwable)e2);
                        }
                    }
                    if (raf == null) break block45;
                    try {
                        raf.close();
                    }
                    catch (IOException e3) {
                        logger.error(e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public static String path(String path) {
        String p = StringUtils.replace((String)path, (String)"\\", (String)"/");
        if (!StringUtils.startsWithAny((CharSequence)(p = StringUtils.join((Object[])StringUtils.split((String)p, (String)"/"), (String)"/")), (CharSequence[])new CharSequence[]{"/"}) && StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"\\", "/"})) {
            p = String.valueOf(p) + "/";
        }
        if (!StringUtils.endsWithAny((CharSequence)p, (CharSequence[])new CharSequence[]{"/"}) && StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"\\", "/"})) {
            p = String.valueOf(p) + "/";
        }
        if (path != null && path.startsWith("/")) {
            p = "/" + p;
        }
        return p;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1 || fileName.lastIndexOf(".") == fileName.length() - 1) {
            return null;
        }
        return StringUtils.lowerCase((String)fileName.substring(fileName.lastIndexOf(".") + 1));
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1) {
            return null;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static void getFileToList(String filepath, List<File> filelist, String filetype) {
        File[] files = FileUtils.listFiles(filepath);
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            File file = f.getAbsoluteFile();
            if (file.isFile()) {
                String suffix = file.getName().substring(file.getName().lastIndexOf(".") + 1);
                if (filetype == null || filetype.equalsIgnoreCase(suffix)) {
                    filelist.add(file);
                }
            } else {
                FileUtils.getFileToList(file.getAbsolutePath(), filelist, filetype);
            }
            ++n2;
        }
    }

    public static File getFileFromPath(String filepath, String fileName) {
        File[] files = FileUtils.listFiles(filepath);
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(fileName)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public static void fileCopy(File sourcefile, File destfile) throws Exception {
        if (sourcefile == null) {
            throw new IllegalArgumentException("source file is null");
        }
        if (destfile == null) {
            throw new IllegalArgumentException("destination file is null");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(sourcefile);
                fos = new FileOutputStream(destfile);
                byte[] b = new byte[102400];
                int temp = 0;
                while ((temp = fis.read(b)) != -1) {
                    fos.write(b, 0, temp);
                }
                fos.flush();
            }
            catch (Exception e) {
                throw new Exception("copy file to destination occurrence error", e);
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e2) {
                throw new Exception("copy file to destination when close stream occurrence error", e2);
            }
        }
    }

    public static File[] listFiles(String filepath) {
        if (filepath == null) {
            throw new IllegalArgumentException("the file path is null");
        }
        File file = new File(filepath);
        if (file.isDirectory()) {
            return file.listFiles();
        }
        return null;
    }

    public static String readFileContent(File file, String charset) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("the file object is null");
        }
        try {
            return IOUtils.getString(new FileInputStream(file), charset);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("the " + file.getName() + " not found");
        }
        catch (Exception e) {
            throw new Exception("read " + file.getName() + " content occurence error");
        }
    }

    public static void writeStringToFile(File file, String str, boolean append, String encoding) {
        OutputStreamWriter writer = null;
        try {
            try {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), encoding);
                writer.write(str);
                writer.flush();
            }
            catch (Exception e) {
                logger.error("FileUtils writeStringToFile(File file, String str, boolean append, String encoding) has error", (Throwable)e);
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

