/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.EncodesUtils;
import com.ckjava.xutils.StringUtils;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils
extends StringUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);
    private static int DEFAULT_KEY_LEN = 16;
    private static final String CipherMode = "AES/ECB/PKCS5Padding";

    public static void setKeyLength(int keyLength) {
        DEFAULT_KEY_LEN = keyLength;
    }

    private static SecretKeySpec createKey(String password, int keyLength) {
        if (password == null) {
            password = "";
        }
        StringBuilder str = new StringBuilder(keyLength);
        str.append(password);
        while (str.length() < keyLength) {
            str.append("0");
        }
        if (str.length() > keyLength) {
            str.setLength(keyLength);
        }
        try {
            byte[] data = str.toString().getBytes("UTF-8");
            return new SecretKeySpec(data, "AES");
        }
        catch (Exception e) {
            logger.error("AESUtils createKey has error", (Throwable)e);
            return null;
        }
    }

    public static byte[] encrypt(byte[] content, String password) {
        try {
            SecretKeySpec key = AESUtils.createKey(password, DEFAULT_KEY_LEN);
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(1, key);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            logger.error("AESUtils encrypt has error", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String content, String password) {
        try {
            byte[] data = content.getBytes("UTF-8");
            byte[] encryptData = AESUtils.encrypt(data, password);
            return EncodesUtils.byte2HexString(encryptData);
        }
        catch (Exception e) {
            logger.error("AESUtils encrypt has error", (Throwable)e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            SecretKeySpec key = AESUtils.createKey(password, DEFAULT_KEY_LEN);
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(2, key);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            logger.error("AESUtils createKey has error", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String hexString, String password) {
        try {
            byte[] data = EncodesUtils.hexString2Byte(hexString);
            byte[] decryptData = AESUtils.decrypt(data, password);
            return new String(decryptData, "UTF-8");
        }
        catch (Exception e) {
            logger.error("AESUtils decrypt has error", (Throwable)e);
            return null;
        }
    }

    public static int parse(char c) {
        if (c >= 'a') {
            return c - 97 + 10;
        }
        if (c >= 'A') {
            return c - 65 + 10;
        }
        return c - 48;
    }
}

