/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class ArrayUtils
extends org.apache.commons.lang3.ArrayUtils {
    public static <T> T getValue(T[] arr, int index) {
        if (arr == null || arr.length == 0 || index > arr.length - 1 || index < 0) {
            return null;
        }
        return arr[index];
    }

    public static <T> T getValue(T[] arr, int index, T defaultValue) {
        if (arr == null || arr.length == 0 || index > arr.length - 1 || index < 0) {
            return defaultValue;
        }
        return arr[index] == null ? defaultValue : arr[index];
    }

    public static <T> int getSize(T[] arr) {
        return arr == null ? 0 : arr.length;
    }

    public static <T> String join(T[] arr, String separator) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (T t : arr) {
            result.append(t).append(separator);
        }
        return result.toString().substring(0, result.toString().lastIndexOf(separator));
    }

    @SafeVarargs
    public static <T> T[] merge(T[] ... arrs) {
        int size = ArrayUtils.getSize(arrs);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return arrs[0];
        }
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            Object[] t = (Object[])ArrayUtils.getValue(arrs, i);
            int c = ArrayUtils.getSize(t);
            for (int j = 0; j < c; ++j) {
                tempList.add(ArrayUtils.getValue(t, j));
            }
        }
        Object[] array = (Object[])Array.newInstance(arrs[0].getClass().getComponentType(), tempList.size());
        return tempList.toArray(array);
    }
}

