/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.Constants;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils
implements Constants {
    public static String getDateString(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String getYear(Date date) {
        return DateUtils.getDateString(date, "yyyy");
    }

    public static String getMonth(Date date) {
        return DateUtils.getDateString(date, "MM");
    }

    public static String getDay(Date date) {
        return DateUtils.getDateString(date, "dd");
    }

    public static String getWeek(Date date) {
        return DateUtils.getDateString(date, "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])Constants.TIMEFORMAT.PATTERNS);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date currentDate, Date pastDate) {
        long t = currentDate.getTime() - pastDate.getTime();
        return t / 86400000L;
    }

    public static long pastHours(Date currentDate, Date pastDate) {
        long t = currentDate.getTime() - pastDate.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date currentDate, Date pastDate) {
        long t = currentDate.getTime() - pastDate.getTime();
        return t / 60000L;
    }

    public static String formatTime(long time, String format) {
        Date date = new Date(time);
        return DateUtils.getDateString(date, format);
    }

    public static Date getAssignDay(Date time, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(5, offset);
        return calendar.getTime();
    }

    public static Date getBeginDay(Date time) {
        String dateStr = DateUtils.getDateString(time, "yyyy-MM-dd").concat(" 00:00:00");
        try {
            return DateUtils.parseDate((String)dateStr, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getEndDay(Date time) {
        String dateStr = DateUtils.getDateString(time, "yyyy-MM-dd").concat(" 23:59:59");
        try {
            return DateUtils.parseDate((String)dateStr, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getMonday(Date currentDate) {
        Calendar can = Calendar.getInstance(Locale.CHINA);
        if (currentDate != null) {
            can.setTime(currentDate);
        }
        can.set(7, 2);
        return can.getTime();
    }
}

