/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.Constants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class EncodesUtils
implements Constants {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) throws DecoderException {
        return Hex.decodeHex((char[])input.toCharArray());
    }

    public static String encodeBase64(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String encodeBase64(String input) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])input.getBytes("UTF-8")));
    }

    public static byte[] decodeBase64(String base64String) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])base64String.getBytes("UTF-8"));
    }

    public static String decodeBase64String(String base64String) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((byte[])base64String.getBytes("UTF-8")), "UTF-8");
    }

    public static String urlEncode(String part) throws UnsupportedEncodingException {
        return URLEncoder.encode(part, "UTF-8");
    }

    public static String urlDecode(String part) throws UnsupportedEncodingException {
        return URLDecoder.decode(part, "UTF-8");
    }

    public static byte[] hexString2Byte(String hexString) {
        byte[] b = new byte[hexString.length() / 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            char c0 = hexString.charAt(j++);
            char c1 = hexString.charAt(j++);
            b[i] = (byte)(Character.getNumericValue(c0) << 4 | Character.getNumericValue(c1));
        }
        return b;
    }

    public static String byte2HexString(byte[] bytes) {
        int j = bytes.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = bytes[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }
}

