/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtils
extends IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String digestString(String originalString, String hashType) {
        try {
            byte[] strTemp = originalString.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance(hashType);
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            return HashUtils.byte2HexString(md);
        }
        catch (Exception e) {
            logger.error("HashUtils MD5Digest has error", (Throwable)e);
            return null;
        }
    }

    public static String byte2HexString(byte[] bytes) {
        int j = bytes.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = bytes[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String digestFile(File originalFile, String hashType) {
        DigestInputStream digestInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashType);
            digestInputStream = new DigestInputStream(new FileInputStream(originalFile), messageDigest);
            int bufferSize = 262144;
            byte[] buffer = new byte[bufferSize];
            while (digestInputStream.read(buffer) > 0) {
            }
            messageDigest = digestInputStream.getMessageDigest();
            byte[] resultByteArray = messageDigest.digest();
            String string = HashUtils.byte2HexString(resultByteArray);
            HashUtils.closeQuietly((InputStream)digestInputStream);
            return string;
        }
        catch (Exception e) {
            logger.error("HashUtils digestFile has error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            HashUtils.closeQuietly(digestInputStream);
        }
    }

    public class HASHTYPE {
        public static final String MD2 = "MD2";
        public static final String MD5 = "MD5";
        public static final String SHA1 = "SHA-1";
        public static final String SHA224 = "SHA-224";
        public static final String SHA256 = "SHA-256";
        public static final String SHA384 = "SHA-384";
        public static final String SHA512 = "SHA-512";
    }
}

