/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.Constants;
import com.ckjava.xutils.EncodesUtils;
import com.ckjava.xutils.IOUtils;
import com.ckjava.xutils.StringUtils;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils
extends EncodesUtils
implements Constants {
    private static Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static int timeout = 100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String put(String url, Map<String, String> headers, Map<String, String> parameters, String bodyString) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http put:" + url);
            url = HttpClientUtils.appendRequestParameter(url, parameters);
            HttpPut httpPut = new HttpPut(url);
            String contentType = HttpClientUtils.appendRequestHeader(headers, (AbstractHttpMessage)httpPut);
            HttpClientUtils.addRequestBody(bodyString, (HttpEntityEnclosingRequestBase)httpPut, contentType);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)httpPut);
            return string;
        }
        catch (Exception e) {
            log.error("http put has error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpclient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> headers, Map<String, String> parameters, String bodyString) {
        CloseableHttpClient httpclient = HttpClientUtils.initWeakSSLClient();
        try {
            log.info("create http post:" + url);
            url = HttpClientUtils.appendRequestParameter(url, parameters);
            HttpPost httpost = new HttpPost(url);
            String contentType = HttpClientUtils.appendRequestHeader(headers, (AbstractHttpMessage)httpost);
            HttpClientUtils.addRequestBody(bodyString, (HttpEntityEnclosingRequestBase)httpost, contentType);
            String string = HttpClientUtils.invoke(httpclient, (HttpUriRequest)httpost);
            return string;
        }
        catch (Exception e) {
            log.error("http post has error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpclient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClientUtils.initWeakSSLClient();
        try {
            url = HttpClientUtils.appendRequestParameter(url, params);
            log.info("create http get:" + url);
            HttpGet httpGet = new HttpGet(url);
            HttpClientUtils.appendRequestHeader(headers, (AbstractHttpMessage)httpGet);
            String string = HttpClientUtils.invoke(httpClient, (HttpUriRequest)httpGet);
            return string;
        }
        catch (Exception e) {
            log.error("http get has error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String delete(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpClientUtils.initWeakSSLClient();
        try {
            url = HttpClientUtils.appendRequestParameter(url, params);
            log.info("create http delete:" + url);
            HttpDelete httpDelete = new HttpDelete(url);
            HttpClientUtils.appendRequestHeader(headers, (AbstractHttpMessage)httpDelete);
            String string = HttpClientUtils.invoke(httpClient, (HttpUriRequest)httpDelete);
            return string;
        }
        catch (Exception e) {
            log.error("http delete has error", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpClient);
        }
    }

    private static void addRequestBody(String bodyString, HttpEntityEnclosingRequestBase http, String contentType) {
        String[] supportTypes = new String[]{"text/xml", "application/json"};
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            if (contentType.contains(supportTypes[0])) {
                HttpClientUtils.addXmlBody(http, bodyString);
            } else if (contentType.contains(supportTypes[1])) {
                HttpClientUtils.addJSONBody(http, bodyString);
            }
        }
    }

    private static String appendRequestHeader(Map<String, String> headers, AbstractHttpMessage httpMessage) {
        String contentType = null;
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> data : headers.entrySet()) {
                String key = data.getKey();
                String value = data.getValue();
                if (key.equalsIgnoreCase("Content-Type")) {
                    contentType = value;
                }
                httpMessage.addHeader(key, value);
            }
        }
        return contentType;
    }

    private static String appendRequestParameter(String url, Map<String, String> params) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((CharSequence)url) && params != null && !params.isEmpty()) {
            boolean flag = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (flag && url.indexOf("?") == -1) {
                    url = url + "?" + HttpClientUtils.urlEncode(key) + "=" + HttpClientUtils.urlEncode(value);
                    flag = false;
                    continue;
                }
                url = url + "&" + HttpClientUtils.urlEncode(key) + "=" + HttpClientUtils.urlEncode(value);
            }
        }
        return url;
    }

    private static String invoke(CloseableHttpClient httpclient, HttpUriRequest httprequest) {
        HttpResponse response = HttpClientUtils.sendRequest((HttpClient)httpclient, httprequest);
        return HttpClientUtils.paseResponse(response);
    }

    private static String paseResponse(HttpResponse response) {
        log.info("get response from http server..");
        HttpEntity entity = response.getEntity();
        log.info("response status: " + response.getStatusLine());
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            log.error("paseResponse has error", (Throwable)e);
            return null;
        }
    }

    private static HttpResponse sendRequest(HttpClient httpclient, HttpUriRequest request) {
        log.info("execute request...");
        HttpResponse response = null;
        try {
            response = httpclient.execute(request);
        }
        catch (Exception e) {
            log.error("sendRequest has error", (Throwable)e);
        }
        return response;
    }

    private static void addJSONBody(HttpEntityEnclosingRequestBase http, String bodyString) {
        try {
            StringEntity se = new StringEntity(bodyString, ContentType.create((String)"application/json", (String)"UTF-8"));
            http.setEntity((HttpEntity)se);
        }
        catch (Exception e) {
            log.error("addJSONBody has Exception", (Throwable)e);
        }
    }

    private static void addXmlBody(HttpEntityEnclosingRequestBase http, Object obj) {
        try {
            StringEntity se = new StringEntity(StringUtils.getStr(obj), ContentType.create((String)"text/xml", (String)"UTF-8"));
            http.setEntity((HttpEntity)se);
        }
        catch (Exception e) {
            log.error("addXmlBody has Exception", (Throwable)e);
        }
    }

    private static CloseableHttpClient initWeakSSLClient() {
        HttpClientBuilder b = HttpClientBuilder.create();
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        b.setSslcontext(sslContext);
        X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        b.setConnectionManager((HttpClientConnectionManager)connMgr);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(timeout);
        configBuilder.setSocketTimeout(timeout);
        b.setDefaultRequestConfig(configBuilder.build());
        CloseableHttpClient sslClient = b.build();
        return sslClient;
    }

    public static String addParamValue(String url, String paramname, String value) throws UnsupportedEncodingException {
        if (paramname == null || value == null) {
            return "";
        }
        String tempUrl = url;
        if (HttpClientUtils.isValidUrl(tempUrl = tempUrl + HttpClientUtils.urlEncode(paramname) + "=" + HttpClientUtils.urlEncode(value) + "&")) {
            return tempUrl;
        }
        return url;
    }

    public static boolean isValidUrl(String urlString) {
        URI uri = null;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        if (uri.getHost() == null) {
            return false;
        }
        return uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https");
    }
}

