/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ckjava.xutils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static List<String> resolveJsonString(String jsonString) throws Exception {
        ArrayList<String> dataList = new ArrayList<String>();
        if (jsonString.startsWith("{")) {
            JSONObject object = JSONObject.parseObject((String)jsonString);
            JsonUtils.resolveJSONObject(object, dataList);
        } else if (jsonString.startsWith("[")) {
            JSONArray array = JSONArray.parseArray((String)jsonString);
            JsonUtils.resolveJSONArray(array, dataList);
        } else {
            logger.warn("the jsonString[{}] must be json string", (Object)jsonString);
        }
        return dataList;
    }

    private static void resolveJSONObject(JSONObject object, List<String> dataList) {
        for (String key : object.keySet()) {
            Object value = object.get((Object)key);
            if (value instanceof JSONObject) {
                JsonUtils.resolveJSONObject((JSONObject)value, dataList);
                continue;
            }
            if (value instanceof JSONArray) {
                JsonUtils.resolveJSONArray((JSONArray)value, dataList);
                continue;
            }
            String finalValue = "";
            if (value instanceof String) {
                String valueString = StringUtils.getStr(value);
                if (valueString.startsWith("{") || valueString.startsWith("[")) {
                    valueString = valueString.replace("\"", "\\\"");
                }
                finalValue = "\"" + key + "\":\"" + valueString + "\"";
            } else {
                finalValue = "\"" + key + "\":" + StringUtils.getStr(value);
            }
            dataList.add(key + "=" + finalValue);
        }
    }

    private static void resolveJSONArray(JSONArray array, List<String> dataList) {
        ListIterator it = array.listIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof JSONObject) {
                JsonUtils.resolveJSONObject((JSONObject)value, dataList);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            JsonUtils.resolveJSONArray((JSONArray)value, dataList);
        }
    }
}

