/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.ArrayUtils;
import com.ckjava.xutils.CollectionUtils;
import com.ckjava.xutils.Constants;
import com.ckjava.xutils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtils
extends org.apache.commons.lang3.ObjectUtils
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtils.class);

    public static boolean isEmptyObject(Object obj) {
        Field[] fields;
        if (obj == null || obj.toString().equals("")) {
            return true;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                Object fieldObj;
                boolean flag = field.isAccessible();
                boolean isStatic = Modifier.toString(field.getModifiers()).contains("static");
                if (isStatic) continue;
                if (!flag) {
                    field.setAccessible(true);
                }
                if ((fieldObj = field.get(obj)) == null || fieldObj.toString().equals("")) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                logger.error("ObjectUtils isEmptyObject has error", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isNotEmptyObject(Object obj) {
        Field[] fields;
        if (obj == null || obj.toString().equals("")) {
            return false;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                Object fieldObj;
                boolean flag = field.isAccessible();
                boolean isStatic = Modifier.toString(field.getModifiers()).contains("static");
                if (isStatic) continue;
                if (!flag) {
                    field.setAccessible(true);
                }
                if ((fieldObj = field.get(obj)) != null && !fieldObj.toString().equals("")) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static String getObjectString(Object obj) {
        if (obj == null || obj.toString().equals("")) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        StringBuilder data = new StringBuilder();
        for (Field field : fields) {
            try {
                Object fieldObj;
                Class<?> clazz;
                boolean flag = field.isAccessible();
                boolean isStatic = Modifier.toString(field.getModifiers()).contains("static");
                if (isStatic) continue;
                if (!flag) {
                    field.setAccessible(true);
                }
                if ((clazz = field.getType()).equals(obj.getClass()) || (fieldObj = field.get(obj)) == null || fieldObj.toString().equals("")) continue;
                data.append(field.getName()).append("=").append(String.valueOf(fieldObj)).append("&");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return data.toString();
    }

    public static Map<String, String> fillMapWithString(String data) {
        String[] datas;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)data)) {
            return dataMap;
        }
        for (String str : datas = data.split("&")) {
            String[] keyValue = str.split("=");
            String key = ArrayUtils.getValue(keyValue, 0);
            String value = ArrayUtils.getValue(keyValue, 1);
            dataMap.put(StringUtils.trim((String)key), StringUtils.trim((String)value));
        }
        return dataMap;
    }

    public static Map<String, String> fillMapWithString(String data, String spliter, int limit) {
        String[] datas;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)data)) {
            return dataMap;
        }
        for (String str : datas = data.split(spliter)) {
            String[] keyValue = str.split("=", limit);
            String key = ArrayUtils.getValue(keyValue, 0);
            String value = ArrayUtils.getValue(keyValue, 1);
            dataMap.put(StringUtils.trim((String)key), StringUtils.trim((String)value));
        }
        return dataMap;
    }

    public static Map<String, String> fillMapWithString(String data, String spliter1, String spliter2) {
        String[] datas;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)data)) {
            return dataMap;
        }
        for (String str : datas = data.split(spliter1)) {
            String[] keyValue = str.split(spliter2);
            String key = ArrayUtils.getValue(keyValue, 0);
            String value = ArrayUtils.getValue(keyValue, 1);
            dataMap.put(StringUtils.trim((String)key), StringUtils.trim((String)value));
        }
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("ObjectUtils.objectToBytes has error", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                oos.close();
                baos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bytesToObject(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            logger.error("ObjectUtils.bytesToObject has error", (Throwable)e);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            try {
                ois.close();
                bais.close();
            }
            catch (Exception exception) {}
        }
    }

    public static <T> Map<String, String> mPull(List<T> dataList, String mKey, String mValue) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        int c = CollectionUtils.getSize(dataList);
        for (int i = 0; i < c; ++i) {
            T t = dataList.get(i);
            Class<?> clazz = t.getClass();
            Method[] methods = clazz.getDeclaredMethods();
            String key = null;
            String value = null;
            Object[] emptyObj = new Object[]{};
            for (Method method : methods) {
                String methodName = method.getName();
                if (methodName.equals(mKey)) {
                    key = StringUtils.getStr(ObjectUtils.invokeMethod(t, emptyObj, method));
                }
                if (!methodName.equals(mValue)) continue;
                value = StringUtils.getStr(ObjectUtils.invokeMethod(t, emptyObj, method));
            }
            if (!StringUtils.isNotBlank(key)) continue;
            resultMap.put(key, value);
        }
        return resultMap;
    }

    private static <T> Object invokeMethod(T t, Object[] emptyObj, Method method) {
        try {
            return method.invoke(t, emptyObj);
        }
        catch (Exception e) {
            logger.error("CollectionUtils invokeMethod has error", (Throwable)e);
            return null;
        }
    }
}

