/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils
extends org.apache.commons.lang3.StringUtils
implements Constants {
    @Deprecated
    public static String getCleanXmlString(Object original) {
        String data = StringUtils.getStr(original);
        data = data.replaceAll("&", "&amp;");
        data = data.replaceAll("<", "&lt;");
        data = data.replaceAll(">", "&gt;");
        data = data.replaceAll("\"", "&quot;");
        data = data.replaceAll("'", "&apos;");
        data = data.replaceAll("\u2022", "&#8226;");
        return data;
    }

    @Deprecated
    public static String getDecodeCleanXmlString(Object original) {
        String data = StringUtils.getStr(original);
        data = data.replaceAll("&amp;", "&");
        data = data.replaceAll("&lt;", "<");
        data = data.replaceAll("&gt;", ">");
        data = data.replaceAll("&quot;", "\"");
        data = data.replaceAll("&apos;", "'");
        return data;
    }

    public static String getStr(Object obj) {
        return obj != null ? obj.toString() : "";
    }

    public static String getStr(Object obj, String defaultStr) {
        String str = StringUtils.getStr(obj);
        return str.equals("") ? defaultStr : str;
    }

    public static boolean objectHasStr(Object obj, String str) {
        String objStr = StringUtils.getStr(obj);
        return objStr.contains(str);
    }

    public static boolean containsStr(String str, String[] strs) {
        if (str == null && strs == null) {
            return true;
        }
        if (str == null && strs != null) {
            return false;
        }
        if (str != null && strs == null) {
            return false;
        }
        for (String string : strs) {
            if (!str.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsStrIgnoreCase(String str, String[] strs) {
        if (str == null && strs == null) {
            return true;
        }
        if (str == null && strs != null) {
            return false;
        }
        if (str != null && strs == null) {
            return false;
        }
        for (String string : strs) {
            if (!str.toUpperCase().contains(string.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static String replaceVariable(String sourceString, Map<String, String> placeholderMap) {
        if (StringUtils.isNotBlank((CharSequence)sourceString) && sourceString.contains("${") && sourceString.contains("}")) {
            Pattern pattern = Pattern.compile("(\\$\\{[^\\}.]*\\})");
            Matcher matcher = pattern.matcher(sourceString);
            while (matcher.find()) {
                String matcherStr = matcher.group();
                String variable = matcherStr.replaceAll("\\$\\{", "").replaceAll("\\}", "");
                String variableValue = placeholderMap.get(variable);
                if (!StringUtils.isNotBlank((CharSequence)variableValue)) continue;
                sourceString = sourceString.replace("${" + variable + "}", variableValue);
            }
        }
        return sourceString;
    }

    public static String getStringByFilter(String targetString, String leftBorder, String rightBorder, Integer index) {
        int startpos = targetString.indexOf(leftBorder);
        if (startpos > 0) {
            while (true) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index - 1);
                if (n <= 0) break;
                if (startpos > 0) {
                    targetString = targetString.substring(startpos + leftBorder.length());
                }
                startpos = targetString.indexOf(leftBorder);
            }
            int endpos = targetString.indexOf(rightBorder);
            targetString = endpos > 0 ? targetString.substring(0, endpos) : "";
        } else {
            targetString = "";
        }
        return targetString;
    }

    public static List<String> extractVariable(String targetString) {
        ArrayList<String> variableList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)targetString) && targetString.contains("${") && targetString.contains("}")) {
            Pattern pattern = Pattern.compile("(\\$\\{[^\\}.]*\\})");
            Matcher matcher = pattern.matcher(targetString);
            while (matcher.find()) {
                String matcherStr = matcher.group();
                String variable = matcherStr.replaceAll("\\$\\{", "").replaceAll("\\}", "");
                variableList.add(variable);
            }
        }
        return variableList;
    }

    public static StringDiff levenshtein(String str1, String str2) {
        int a;
        int len1 = str1.length();
        int len2 = str2.length();
        int[][] dif = new int[len1 + 1][len2 + 1];
        for (a = 0; a <= len1; ++a) {
            dif[a][0] = a;
        }
        for (a = 0; a <= len2; ++a) {
            dif[0][a] = a;
        }
        for (int i = 1; i <= len1; ++i) {
            for (int j = 1; j <= len2; ++j) {
                int temp = str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1;
                dif[i][j] = StringUtils.min(dif[i - 1][j - 1] + temp, dif[i][j - 1] + 1, dif[i - 1][j] + 1);
            }
        }
        int diffStep = dif[len1][len2];
        float similarity = 1.0f - (float)dif[len1][len2] / (float)Math.max(str1.length(), str2.length());
        return new StringDiff(str1, str2, diffStep, similarity);
    }

    private static int min(int ... is) {
        int min = Integer.MAX_VALUE;
        for (int i : is) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    public static class StringDiff {
        private String str1;
        private String str2;
        private int diffStep;
        private float similarity;

        public String getStr1() {
            return this.str1;
        }

        public void setStr1(String str1) {
            this.str1 = str1;
        }

        public String getStr2() {
            return this.str2;
        }

        public void setStr2(String str2) {
            this.str2 = str2;
        }

        public int getDiffStep() {
            return this.diffStep;
        }

        public void setDiffStep(int diffStep) {
            this.diffStep = diffStep;
        }

        public float getSimilarity() {
            return this.similarity;
        }

        public void setSimilarity(float similarity) {
            this.similarity = similarity;
        }

        public StringDiff(String str1, String str2, int diffStep, float similarity) {
            this.str1 = str1;
            this.str2 = str2;
            this.diffStep = diffStep;
            this.similarity = similarity;
        }

        public StringDiff() {
        }
    }
}

