/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils;

import com.ckjava.xutils.Constants;
import com.ckjava.xutils.FileUtils;
import com.ckjava.xutils.StringUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtils
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(XmlUtils.class);

    public static <T> T xml2Obj(String xml, Class<T> clazz) throws JAXBException {
        JAXBContext requestContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = requestContext.createUnmarshaller();
        StringReader sr = new StringReader(xml);
        return (T)unmarshaller.unmarshal((Reader)sr);
    }

    public static String convertNode2XmlString(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(new DOMSource(node), result);
        return writer.toString();
    }

    public static String obj2Xml(Object obj, Map<String, Object> marshallerProperties) throws JAXBException {
        JAXBContext responseContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = responseContext.createMarshaller();
        if (marshallerProperties != null && !marshallerProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : marshallerProperties.entrySet()) {
                marshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        StringWriter sw = new StringWriter();
        marshaller.marshal(obj, (Writer)sw);
        return sw.toString();
    }

    public static Node appendObj2Node(Object obj, Node node) throws JAXBException {
        JAXBContext responseContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = responseContext.createMarshaller();
        marshaller.marshal(obj, node);
        return node;
    }

    public static List<String> resolveXmlString(String xmlString) throws Exception {
        Long time = System.currentTimeMillis();
        File xmlFile = new File(String.valueOf(time).concat(".xml"));
        FileUtils.writeStringToFile(xmlFile, xmlString, true, "UTF-8");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ArrayList<String> dataList = new ArrayList<String>();
        SaxHandler dh = new SaxHandler(dataList);
        parser.parse(xmlFile, (DefaultHandler)dh);
        boolean deleteFlag = xmlFile.delete();
        logger.info("\u5220\u9664\u4e34\u65f6xml\u6587\u4ef6, deleteFlag = {}", (Object)deleteFlag);
        return dataList;
    }

    public static class SaxHandler
    extends DefaultHandler {
        private List<String> dataList;
        private String element;
        private String elementContent;

        public SaxHandler(List<String> dataList) {
            this.dataList = dataList;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            super.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            super.fatalError(e);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            System.out.println(new String(ch, start, length));
            super.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            super.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            super.skippedEntity(name);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            super.warning(e);
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.elementContent = new String(arg0, arg1, arg2);
            System.out.print(this.elementContent);
            if (StringUtils.isNotBlank((CharSequence)this.elementContent)) {
                StringBuilder content = new StringBuilder();
                content.append("<").append(this.element).append(">");
                content.append(this.elementContent);
                content.append("</").append(this.element).append(">");
                this.dataList.add(this.element + "=" + content.toString());
            }
            super.characters(arg0, arg1, arg2);
        }

        @Override
        public void endDocument() throws SAXException {
            System.out.println("\n\u7ed3\u675f\u89e3\u6790");
            super.endDocument();
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            System.out.print("</");
            System.out.print(arg2);
            System.out.print(">");
            super.endElement(arg0, arg1, arg2);
        }

        @Override
        public void startDocument() throws SAXException {
            System.out.println("\u5f00\u59cb\u89e3\u6790");
            String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            System.out.println(s);
            super.startDocument();
        }

        @Override
        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            System.out.print("<");
            System.out.print(arg2);
            this.element = arg2;
            if (arg3 != null) {
                for (int i = 0; i < arg3.getLength(); ++i) {
                    System.out.print(" " + arg3.getQName(i) + "=\"" + arg3.getValue(i) + "\"");
                    this.dataList.add(arg3.getQName(i) + "=" + arg3.getQName(i) + "=\"" + arg3.getValue(i) + "\"");
                }
            }
            System.out.print(">");
            super.startElement(arg0, arg1, arg2, arg3);
        }
    }
}

