/*
 * Decompiled with CFR 0.152.
 */
package com.ckjava.xutils.db;

import com.ckjava.xutils.StringUtils;
import com.ckjava.xutils.db.DatabasePoolConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils
extends StringUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbUtils.class);
    private static Map<String, javax.sql.DataSource> dataSourceMap = Collections.synchronizedMap(new HashMap());

    public static javax.sql.DataSource createDataSource(String url, String username, String password) throws Exception {
        String dbKey = DbUtils.getDbKey(url, username, password);
        javax.sql.DataSource ds = dataSourceMap.get(dbKey);
        if (ds == null) {
            DatabasePoolConfig poolConfig = new DatabasePoolConfig();
            PoolProperties p = poolConfig.getPoolProperties();
            p.setUrl(url);
            p.setUsername(username);
            p.setPassword(password);
            if (url.contains("jdbc:mysql")) {
                p.setDriverClassName("com.mysql.jdbc.Driver");
            } else if (url.contains("jdbc:sqlserver")) {
                p.setDriverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            } else if (url.contains("jdbc:sqlite")) {
                p.setDriverClassName("org.sqlite.JDBC");
            } else {
                throw new RuntimeException(MessageFormat.format("can't load DriverClass by url:{0}", url));
            }
            DataSource newDS = new DataSource((PoolConfiguration)p);
            dataSourceMap.put(dbKey, (javax.sql.DataSource)newDS);
            return newDS;
        }
        return ds;
    }

    private static String getDbKey(String url, String username, String password) {
        StringBuilder str = new StringBuilder();
        str.append(url).append("@").append(username).append("@").append(password);
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMutiSql(Connection conn, String sql) {
        int rowcount = 0;
        PreparedStatement ps = null;
        try {
            String[] sqls;
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(2);
            String tempSql = sql.replaceAll(";(\\s*|\t|\r|\n)(?i)insert", "';'insert").replaceAll(";(\\s*|\t|\r|\n)(?i)update", "';'update").replaceAll(";(\\s*|\t|\r|\n)(?i)delete", "';'delete").replaceAll(";(\\s*|\t|\r|\n)(?i)drop", "';'drop").replaceAll(";(\\s*|\t|\r|\n)(?i)create", "';'create");
            for (String sqlstr : sqls = tempSql.split("';'")) {
                ps = conn.prepareStatement(sqlstr);
                rowcount = ps.executeUpdate();
                logger.info("\u6267\u884csql\uff1a{},\u53d7\u5f71\u54cd\u884c\u6570\uff1a{}", new Object[]{sqlstr, rowcount});
            }
            conn.commit();
            conn.setAutoCommit(true);
            DbUtils.closeResource(conn, ps, null);
        }
        catch (SQLException e) {
            logger.error("\u6267\u884csql\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error("\u56de\u6eda\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            rowcount = 0;
        }
        finally {
            DbUtils.closeResource(conn, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMutiSql(Connection conn, String sql, int transactionLevel) {
        int rowcount = 0;
        PreparedStatement ps = null;
        try {
            String[] sqls;
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(transactionLevel);
            String tempSql = sql.replaceAll(";(\\s*|\t|\r|\n)(?i)insert", "';'insert").replaceAll(";(\\s*|\t|\r|\n)(?i)update", "';'update").replaceAll(";(\\s*|\t|\r|\n)(?i)delete", "';'delete").replaceAll(";(\\s*|\t|\r|\n)(?i)drop", "';'drop").replaceAll(";(\\s*|\t|\r|\n)(?i)create", "';'create");
            for (String sqlstr : sqls = tempSql.split("';'")) {
                ps = conn.prepareStatement(sqlstr);
                rowcount = ps.executeUpdate();
                logger.info("\u6267\u884csql\uff1a{},\u53d7\u5f71\u54cd\u884c\u6570\uff1a{}", new Object[]{sqlstr, rowcount});
            }
            conn.commit();
            conn.setAutoCommit(true);
            DbUtils.closeResource(conn, ps, null);
        }
        catch (SQLException e) {
            logger.error("\u6267\u884csql\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error("\u56de\u6eda\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            }
            rowcount = 0;
        }
        finally {
            DbUtils.closeResource(conn, ps, null);
        }
    }

    public static void closeResource(Connection conn, PreparedStatement ps, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u6570\u636e\u5e93\u8d44\u6e90 Connection \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u6570\u636e\u5e93\u8d44\u6e90 PreparedStatement \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u6570\u636e\u5e93\u8d44\u6e90 ResultSet \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

