/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.wit.api;

import com.clivern.wit.api.Contract;
import com.clivern.wit.api.endpoint.MessageEndpoint;
import com.clivern.wit.exception.DataNotFound;
import com.clivern.wit.exception.DataNotValid;
import java.util.HashMap;
import java.util.Map;
import org.pmw.tinylog.Logger;

public class Message
implements Contract {
    public String appId = "";
    public String accessToken = "";
    public String endpointName = "";
    public String contentType = MessageEndpoint.CONTENT_TYPE;
    public String url = "";
    public String method = "";
    public Map<String, String> data = new HashMap<String, String>();
    public String finalData = "";
    public Map<String, String> headers = new HashMap<String, String>();
    public String q = "";
    public String context = "";
    public String msgId = "";
    public String threadId = "";
    public Integer n;
    public Boolean verbose;

    public Message(String endpointName) {
        this.endpointName = endpointName;
    }

    public Message(String endpointName, String contentType) {
        this.endpointName = endpointName;
        this.contentType = contentType;
    }

    @Override
    public Boolean config() throws DataNotValid, DataNotFound {
        this.headers.put("Authorization", "Bearer " + this.accessToken);
        this.headers.put("Content-Type", this.contentType);
        if (this.endpointName.equals(MessageEndpoint.GET)) {
            this.url = MessageEndpoint.GET_ENDPOINT;
            this.method = MessageEndpoint.GET_METHOD;
            if (this.q.trim().equals("")) {
                Logger.error((String)"Error! Message user query is required.");
                throw new DataNotFound("Error! Message user query is required.");
            }
            if (this.n != null && (this.n < 1 || this.n > 8)) {
                Logger.error((String)"Error! n-best trait must be from 1 to 8.");
                throw new DataNotFound("Error! n-best trait must be from 1 to 8.");
            }
        } else {
            Logger.error((String)"Error! Invalid endpointName Value.");
            throw new DataNotValid("Error! Invalid endpointName Value.");
        }
        if (!this.data.isEmpty()) {
            this.finalData = this.finalData + "{";
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.finalData = this.finalData + "\"" + key + "\":\"" + value + "\",";
            }
            this.finalData = this.finalData.replaceAll(",$", "");
            this.finalData = this.finalData + "}";
        }
        this.url = this.url.replace("{$Q}", this.q);
        this.url = this.context.equals("") ? this.url.replace("&context={$CONTEXT}", "") : this.url.replace("{$CONTEXT}", this.context);
        this.url = this.msgId.equals("") ? this.url.replace("&msg_id={$MSG_ID}", "") : this.url.replace("{$MSG_ID}", this.msgId);
        this.url = this.threadId.equals("") ? this.url.replace("&thread_id={$THREAD_ID}", "") : this.url.replace("{$THREAD_ID}", this.threadId);
        this.url = this.n == null ? this.url.replace("&n={$N}", "") : this.url.replace("{$N}", this.n.toString());
        this.url = this.verbose == null ? this.url.replace("&verbose={$VERBOSE}", "") : this.url.replace("{$VERBOSE}", this.verbose != false ? "true" : "false");
        return true;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getQ() {
        return this.q;
    }

    public String getContext() {
        return this.context;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public String getData() {
        return this.finalData;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setAppId(String appId) {
        if (this.appId.equals("")) {
            this.appId = appId;
        }
    }

    @Override
    public void setAccessToken(String accessToken) {
        if (this.accessToken.equals("")) {
            this.accessToken = accessToken;
        }
    }

    @Override
    public String debug() {
        String debug = "> curl -X" + this.method + " '" + this.url + "'";
        if (!this.headers.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                debug = debug + " -H \"" + key + ": " + value + "\"";
            }
        }
        if (!this.getData().equals("")) {
            debug = debug + " -d '" + this.getData() + "'";
        }
        return debug;
    }
}

