/*
 * Decompiled with CFR 0.152.
 */
package com.clivern.wit.util;

import com.clivern.wit.exception.DataNotFound;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.pmw.tinylog.Logger;

public class Http {
    protected Boolean isOk;
    protected Response response;
    protected String responseStr;
    protected String url;
    protected String method;
    protected String body;
    protected Map<String, String> headers;

    public Http(String url, String method, Map<String, String> headers) {
        this.url = url;
        this.method = method;
        this.headers = headers;
    }

    public Http(String url, String method, Map<String, String> headers, String body) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
    }

    public String execute() throws DataNotFound, IOException {
        if (!this.headers.containsKey("Content-Type") || !this.headers.containsKey("Authorization")) {
            Logger.error((String)"Error! Content-Type and Authorization required to make a request.");
            throw new DataNotFound("Error! Content-Type and Authorization required to make a request.");
        }
        this.url = this.url.replaceAll(" ", "%20");
        OkHttpClient client = new OkHttpClient();
        MediaType mediaType = MediaType.parse((String)this.headers.get("Content-Type"));
        if (this.method.equals("GET")) {
            Request request = new Request.Builder().url(this.url).get().addHeader("Authorization", this.headers.get("Authorization")).addHeader("Content-Type", this.headers.get("Content-Type")).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        if (this.method.equals("POST")) {
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)this.body);
            Request request = new Request.Builder().url(this.url).post(body).addHeader("Authorization", this.headers.get("Authorization")).addHeader("Content-Type", this.headers.get("Content-Type")).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        if (this.method.equals("PUT")) {
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)this.body);
            Request request = new Request.Builder().url(this.url).put(body).addHeader("Authorization", this.headers.get("Authorization")).addHeader("Content-Type", this.headers.get("Content-Type")).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        if (this.method.equals("DELETE")) {
            Request request = new Request.Builder().url(this.url).delete(null).addHeader("Authorization", this.headers.get("Authorization")).addHeader("Content-Type", this.headers.get("Content-Type")).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        return "";
    }
}

