/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.metadata;

import com.cloudbees.clickstack.domain.metadata.Resource;
import java.util.Arrays;
import java.util.List;

public class Email
extends Resource {
    public static final String HOST_PROPERTY = "SENDGRID_SMTP_HOST";
    public static final String USERNAME_PROPERTY = "SENDGRID_USERNAME";
    public static final String PASSWORD_PROPERTY = "SENDGRID_PASSWORD";
    public static final List<String> TYPES = Arrays.asList("email");

    protected static boolean checkResource(Resource resource) {
        boolean isValid = resource != null;
        if (isValid) {
            isValid = TYPES.contains(resource.getType());
            isValid = isValid && resource.getProperty(HOST_PROPERTY) != null;
            isValid = isValid && resource.getProperty(USERNAME_PROPERTY) != null;
            isValid = isValid && resource.getProperty(PASSWORD_PROPERTY) != null;
        }
        return isValid;
    }

    protected Email(Resource resource) {
        super(resource.getProperties(), resource.getDescriptors());
        if (!Email.checkResource(resource)) {
            throw new IllegalArgumentException("Incorrect email resource definition.");
        }
    }

    public String getHost() {
        return this.getProperty(HOST_PROPERTY);
    }

    public String getUsername() {
        return this.getProperty(USERNAME_PROPERTY);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY);
    }
}

