/*
 * Copyright 2010-2013, CloudBees Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.cloudbees.clickstack.plugin.java;

import com.google.common.base.Preconditions;

import javax.annotation.Nonnull;
import java.nio.file.Path;

/**
 * Result of {@link JavaPlugin#setup(com.cloudbees.clickstack.domain.metadata.Metadata, com.cloudbees.clickstack.domain.environment.Environment)}
 *
 * @author <a href="mailto:cleclerc@cloudbees.com">Cyrille Le Clerc</a>
 */
public class JavaPluginResult {
    @Nonnull
    private final Path javaHome;
    @Nonnull
    private final Path javaExecutable;

    public JavaPluginResult(@Nonnull Path javaHome, Path javaExecutable) {
        this.javaHome = Preconditions.checkNotNull(javaHome, "javaHome");
        this.javaExecutable = Preconditions.checkNotNull(javaExecutable, "javaExecutable");
    }

    @Nonnull
    public Path getJavaHome() {
        return javaHome;
    }

    @Nonnull
    public Path getJavaExecutable() {
        return javaExecutable;
    }

    @Override
    public String toString() {
        return "JavaPluginResult{" +
                "javaHome=" + javaHome +
                "javaExecutable=" + javaExecutable +
                '}';
    }
}
