/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.metadata;

import com.cloudbees.clickstack.domain.metadata.Resource;
import com.cloudbees.clickstack.util.Strings2;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public class Database
extends Resource {
    public static final String DRIVER_POSTGRES = "postgres";
    public static final String DRIVER_MYSQL = "mysql";
    public static final String DRIVER_MS_SQLSERVER = "sql";
    public static final String DRIVER_ORACLE = "oracle";
    public static final String URL_PROPERTY = "DATABASE_URL";
    public static final String USERNAME_PROPERTY = "DATABASE_USERNAME";
    public static final String PASSWORD_PROPERTY = "DATABASE_PASSWORD";
    public static final List<String> TYPES = Arrays.asList("datasource", "database");

    protected static Database newDatabase(String url, String username, String password) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(URL_PROPERTY, url);
        properties.put(USERNAME_PROPERTY, username);
        properties.put(PASSWORD_PROPERTY, password);
        HashMap<String, String> descriptors = new HashMap<String, String>();
        descriptors.put("resource_name", "mydb");
        descriptors.put("resource_type", "database");
        return new Database(new Resource(properties, descriptors));
    }

    public Database(Resource resource) {
        super(resource.getProperties(), resource.getDescriptors());
        if (!Database.checkResource(resource)) {
            throw new IllegalArgumentException("Incorrect database resource definition.");
        }
    }

    public static String getDriver(String url) {
        if (url.matches("^mysql://.*$")) {
            return DRIVER_MYSQL;
        }
        if (url.matches("^sqlserver://.*$")) {
            return DRIVER_MS_SQLSERVER;
        }
        if (url.matches("^postgresql://.*$")) {
            return DRIVER_POSTGRES;
        }
        if (url.matches("^oracle:.*$")) {
            return DRIVER_ORACLE;
        }
        return null;
    }

    @Nullable
    public static String getJavaDriver(String driver) {
        if (driver.equals(DRIVER_MYSQL)) {
            return "com.mysql.jdbc.Driver";
        }
        if (driver.equals(DRIVER_MS_SQLSERVER)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (driver.equals(DRIVER_POSTGRES)) {
            return "org.postgresql.Driver";
        }
        if (driver.equals(DRIVER_ORACLE)) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    @Nullable
    public static String getDataSourceClassName(String driver) {
        if (driver.equals(DRIVER_MYSQL)) {
            return "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
        }
        if (driver.equals(DRIVER_MS_SQLSERVER)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDataSource";
        }
        if (driver.equals(DRIVER_POSTGRES)) {
            return "org.postgresql.ds.PGSimpleDataSource";
        }
        if (driver.equals(DRIVER_ORACLE)) {
            return "oracle.jdbc.pool.OracleDataSource";
        }
        return null;
    }

    @Nullable
    public static String getValidationQuery(String driver) {
        if (driver.equals(DRIVER_MYSQL)) {
            return "select 1";
        }
        if (driver.equals(DRIVER_MS_SQLSERVER)) {
            return "select 1";
        }
        if (driver.equals(DRIVER_POSTGRES)) {
            return "select version();";
        }
        if (driver.equals(DRIVER_ORACLE)) {
            return "select 1 from dual";
        }
        return null;
    }

    protected static boolean checkResource(Resource resource) {
        boolean isValid = resource != null;
        if (isValid) {
            isValid = TYPES.contains(resource.getType());
            isValid = isValid && resource.getProperty(URL_PROPERTY) != null;
            isValid = isValid && resource.getProperty(USERNAME_PROPERTY) != null;
            isValid = isValid && resource.getProperty(PASSWORD_PROPERTY) != null;
            isValid = isValid && Database.getDriver(resource.getProperty(URL_PROPERTY)) != null;
        }
        return isValid;
    }

    @Nullable
    public String getUrl() {
        return this.getProperty(URL_PROPERTY);
    }

    @Nullable
    public String getUsername() {
        return this.getProperty(USERNAME_PROPERTY);
    }

    @Nullable
    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY);
    }

    @Nullable
    public String getDriver() {
        return Database.getDriver(this.getProperty(URL_PROPERTY));
    }

    @Nullable
    public String getJavaDriver() {
        return Database.getJavaDriver(Database.getDriver(this.getProperty(URL_PROPERTY)));
    }

    @Nullable
    public String getDataSourceClassName() {
        return Database.getDataSourceClassName(Database.getDriver(this.getProperty(URL_PROPERTY)));
    }

    @Nullable
    public String getValidationQuery() {
        return Database.getValidationQuery(Database.getDriver(this.getProperty(URL_PROPERTY)));
    }

    @Nullable
    public String getDatabaseName() {
        String connectionUrl = this.getProperty(URL_PROPERTY);
        return Strings2.substringAfterLast(connectionUrl, '/');
    }

    public int getMaxConnections() {
        String databaseUrl = this.getUrl();
        int databaseMaxConnections = databaseUrl == null ? 20 : (databaseUrl.contains("elephantsql.com") ? 4 : (databaseUrl.contains(".cleardb.net") && databaseUrl.contains("-cb-") ? 10 : 20));
        int spareConnections = 1;
        return Math.max(databaseMaxConnections - spareConnections, 1);
    }
}

