/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static Element getUniqueElement(Document document, String xpathExpression) {
        return XmlUtils.getUniqueElement((Node)document, xpathExpression);
    }

    public static Element getUniqueElement(Element element, String xpathExpression) {
        return XmlUtils.getUniqueElement((Node)element, xpathExpression);
    }

    public static Element getUniqueElement(Node element, String xpathExpression) {
        try {
            NodeList nl = (NodeList)xpath.compile(xpathExpression).evaluate(element, XPathConstants.NODESET);
            if (nl.getLength() == 0 || nl.getLength() > 1) {
                throw new RuntimeException("More or less (" + nl.getLength() + ") than 1 element found for expression: " + xpathExpression);
            }
            return (Element)nl.item(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception evaluating xpath '" + xpathExpression + "' on " + element, e);
        }
    }

    public static Document loadXmlDocumentFromFile(@Nonnull File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    public static Document loadXmlDocumentFromPath(@Nonnull Path path) throws ParserConfigurationException, IOException, SAXException {
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File not found %s", (Object[])new Object[]{path});
        Preconditions.checkArgument((!Files.isDirectory(path, new LinkOption[0]) ? 1 : 0) != 0, (String)"Expected file and not directory: %s", (Object[])new Object[]{path});
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(Files.newInputStream(path, new OpenOption[0]));
    }

    public static Document loadXmlDocumentFromStream(@Nonnull InputStream in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(in);
    }

    public static void checkRootElement(@Nonnull Document document, @Nullable String expectedRootElementName) {
        if (document.getDocumentElement() == null || expectedRootElementName == null) {
            return;
        }
        if (!expectedRootElementName.equals(document.getDocumentElement().getNodeName())) {
            throw new IllegalStateException("Invalid root element '" + document.getDocumentElement().getNodeName() + "', expected '" + expectedRootElementName + "'");
        }
    }

    public static void flush(Document in, OutputStream out) throws RuntimeException {
        XmlUtils.flush(in, out, new HashMap<String, String>());
    }

    public static void flush(Document in, OutputStream out, Map<String, String> outputProperties) {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("standalone", "no");
            for (Map.Entry<String, String> property : outputProperties.entrySet()) {
                transformer.setOutputProperty(property.getKey(), property.getValue());
            }
            transformer.transform(new DOMSource(in), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new RuntimeException("Exception flush document", e);
        }
    }

    public static void insertSiblingAfter(Element newElement, Element sibling) {
        Node nextSibling = sibling.getNextSibling();
        sibling.getParentNode().insertBefore(newElement, nextSibling);
    }

    static {
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception disabling 'http://apache.org/xml/features/nonvalidating/load-external-dtd'", e);
        }
    }
}

