/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files2 {
    static final Set<PosixFilePermission> PERMISSION_R = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r-----"));
    static final Set<PosixFilePermission> PERMISSION_RX = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
    static final Set<PosixFilePermission> PERMISSION_RW = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
    static final Set<PosixFilePermission> PERMISSION_RWX = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxrwx---"));
    static final Set<PosixFilePermission> PERMISSION_750 = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
    static final Set<PosixFilePermission> PERMISSION_770 = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxrwx---"));
    static final Set<PosixFilePermission> PERMISSION_640 = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r-----"));
    private static final Logger logger = LoggerFactory.getLogger(Files2.class);

    public static void deleteDirectory(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                logger.trace("Delete file: {} ...", (Object)file);
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    logger.trace("Delete dir: {} ...", (Object)dir);
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }

    public static void chmodReadOnly(Path path) throws IOException {
        SimpleFileVisitor<Path> setReadOnlyFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new IllegalStateException("no dir expected here");
                }
                Files.setPosixFilePermissions(file, PERMISSION_R);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.setPosixFilePermissions(dir, PERMISSION_RX);
                return super.preVisitDirectory(dir, attrs);
            }
        };
        Files.walkFileTree(path, (FileVisitor<? super Path>)setReadOnlyFileVisitor);
    }

    public static void chmodSetReadOnly(@Nonnull Path path) throws IOException {
        Files2.chmodOverwritePermissions(path, PERMISSION_R, PERMISSION_RX);
    }

    public static void chmodAddReadExecute(@Nonnull Path path) throws IOException {
        Files2.chmodAddPermissions(path, PERMISSION_RX, PERMISSION_RX);
    }

    public static void chmodAddReadWrite(@Nonnull Path path) throws IOException {
        Files2.chmodAddPermissions(path, PERMISSION_RW, PERMISSION_RWX);
    }

    @Deprecated
    public static void chmodReadExecute(Path path) throws IOException {
        Files2.chmodAddReadExecute(path);
    }

    @Deprecated
    public static void chmodReadWrite(Path path) throws IOException {
        Files2.chmodAddReadWrite(path);
    }

    private static FileSystem createZipFileSystem(Path zipFile, boolean create) throws IOException {
        URI uri = URI.create("jar:file:" + zipFile.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static void unzip(String zipFilename, String destDirname) throws IOException {
        Path zipFile = Paths.get(zipFilename, new String[0]);
        Path destDir = Paths.get(destDirname, new String[0]);
        Files2.unzip(zipFile, destDir);
    }

    public static void unzipSubDirectoryIfExists(Path zipFile, String zipSubPath, final Path destDir) throws IOException {
        if (Files.notExists(destDir, new LinkOption[0])) {
            logger.trace("Create dir: {}", (Object)destDir);
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = Files2.createZipFileSystem(zipFile, false);){
            final Path root = zipFileSystem.getPath(zipSubPath, new String[0]);
            if (Files.notExists(root, new LinkOption[0])) {
                logger.trace("Zip sub path {} does not exist in {}", (Object)zipSubPath, (Object)zipFile);
                return;
            }
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(destDir.toString(), root.relativize(file).toString());
                    logger.trace("Extract file {} to {} as {}", new Object[]{file, destDir, destFile});
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    dir.relativize(root).toString();
                    Path dirToCreate = Paths.get(destDir.toString(), root.relativize(dir).toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        logger.trace("Create dir {}", (Object)dirToCreate);
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unzip(Path zipFile, final Path destDir) throws IOException {
        if (Files.notExists(destDir, new LinkOption[0])) {
            logger.trace("Create dir: {}", (Object)destDir);
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = Files2.createZipFileSystem(zipFile, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(destDir.toString(), file.toString());
                    logger.trace("Extract file {} to {}", (Object)file, (Object)destDir);
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        logger.trace("Create dir {}", (Object)dirToCreate);
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void untgz(String tgzFilename, String destDirname) throws IOException {
        Path tgzFile = Paths.get(tgzFilename, new String[0]);
        Path destDir = Paths.get(destDirname, new String[0]);
        Files2.untgz(tgzFile, destDir);
    }

    public static void untgz(@Nonnull Path tgzFile, @Nonnull Path destDir) throws IOException {
        TarArchiveEntry entry;
        if (Files.notExists(destDir, new LinkOption[0])) {
            logger.trace("Create dir: {}", (Object)destDir);
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(Files.newInputStream(tgzFile, new OpenOption[0])));
        while ((entry = in.getNextTarEntry()) != null) {
            if (entry.isDirectory()) {
                Path dir = destDir.resolve(entry.getName());
                logger.trace("Create dir {}", (Object)dir);
                Files.createDirectories(dir, new FileAttribute[0]);
                continue;
            }
            Path file = destDir.resolve(entry.getName());
            logger.trace("Create file {}: {} bytes", (Object)file, (Object)entry.getSize());
            OutputStream out = Files.newOutputStream(file, new OpenOption[0]);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
        }
        in.close();
    }

    public static void dump(Path path) throws IOException {
        System.err.println("## DUMP FOLDER TREE ##");
        Files2.dump(path, 0);
    }

    private static void dump(Path path, int depth) throws IOException {
        String icon = Files.isDirectory(path, new LinkOption[0]) ? " + " : " |- ";
        System.out.println(Strings.repeat((String)" ", (int)(++depth)) + icon + path.getFileName() + "\t" + PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0])));
        if (Files.isDirectory(path, new LinkOption[0])) {
            DirectoryStream<Path> children = Files.newDirectoryStream(path);
            for (Path child : children) {
                Files2.dump(child, depth);
            }
        }
    }

    public static void copyDirectoryContent(final Path fromDir, final Path toDir) throws IOException {
        logger.trace("Copy from {} to {}", (Object)fromDir, (Object)toDir);
        SimpleFileVisitor<Path> copyDirVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetPath = toDir.resolve(fromDir.relativize(dir));
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Files.createDirectory(targetPath, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, toDir.resolve(fromDir.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(fromDir, (FileVisitor<? super Path>)copyDirVisitor);
    }

    @Nonnull
    public static Path copyToDirectory(@Nonnull Path source, @Nonnull Path dest) throws IOException {
        Preconditions.checkArgument((boolean)Files.exists(dest, new LinkOption[0]), (Object)"Dest %s not found");
        Preconditions.checkArgument((boolean)Files.isDirectory(dest, new LinkOption[0]), (Object)"Dest %s is not a directory");
        return Files.copy(source, dest.resolve(source.getFileName()), new CopyOption[0]);
    }

    @Nonnull
    public static Path copyArtifactToDirectory(@Nonnull Path sourceDir, @Nonnull String artifactId, @Nonnull Path dest) throws IOException {
        Path source = Files2.findArtifact(sourceDir, artifactId);
        return Files.copy(source, dest.resolve(source.getFileName()), new CopyOption[0]);
    }

    @Nonnull
    public static Path findArtifact(@Nonnull Path source, @Nonnull String artifactId) throws IOException {
        return Files2.findArtifact(source, artifactId, "jar");
    }

    @Deprecated
    @Nonnull
    public static Path findUniqueFolderBeginningWith(@Nonnull Path source, @Nullable String pattern) throws IOException, NoSuchElementException, IllegalStateException {
        return Files2.findUniqueDirectoryBeginningWith(source, pattern);
    }

    @Nonnull
    public static Path findUniqueDirectoryBeginningWith(Path source, final String pattern) throws IOException {
        Preconditions.checkArgument((boolean)Files.isDirectory(source, new LinkOption[0]), (String)"Source %s is not a directory", (Object[])new Object[]{source.toAbsolutePath()});
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String fileName = entry.getFileName().toString();
                if (pattern == null) {
                    return true;
                }
                return fileName.startsWith(pattern);
            }
        };
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(source, (DirectoryStream.Filter<? super Path>)filter);){
            Path path = (Path)Iterables.getOnlyElement(paths);
            return path;
        }
    }

    @Nonnull
    public static Path findUniqueChildDirectory(Path source) throws IOException {
        Preconditions.checkArgument((boolean)Files.isDirectory(source, new LinkOption[0]), (String)"Source %s is not a directory", (Object[])new Object[]{source.toAbsolutePath()});
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(source);){
            Path path = (Path)Iterables.getOnlyElement(paths);
            return path;
        }
    }

    @Nonnull
    public static Path findArtifact(@Nonnull Path source, final @Nonnull String artifactId, final @Nonnull String type) throws IOException {
        Preconditions.checkArgument((boolean)Files.isDirectory(source, new LinkOption[0]), (String)"Source %s is not a directory", (Object[])new Object[]{source.toAbsolutePath()});
        DirectoryStream<Path> paths = Files.newDirectoryStream(source, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String fileName = entry.getFileName().toString();
                return fileName.startsWith(artifactId) && fileName.endsWith("." + type);
            }
        });
        try {
            return (Path)Iterables.getOnlyElement(paths);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Artifact '" + artifactId + ":" + type + "' not found in path: " + source + ", absolutePath: " + source.toAbsolutePath());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("More than 1 version of artifact '" + artifactId + ":" + type + "' found in path: " + source + ", absolutePath: " + source.toAbsolutePath() + " -> " + paths);
        }
    }

    private static void chmodOverwritePermissions(@Nonnull Path path, final @Nonnull Set<PosixFilePermission> filePermission, final @Nonnull Set<PosixFilePermission> folderPermission) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Given path " + path + " does not exist");
        }
        SimpleFileVisitor<Path> setReadOnlyFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new IllegalStateException("No dir expected here: " + file);
                }
                Files.setPosixFilePermissions(file, filePermission);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.setPosixFilePermissions(dir, folderPermission);
                return super.preVisitDirectory(dir, attrs);
            }
        };
        Files.walkFileTree(path, (FileVisitor<? super Path>)setReadOnlyFileVisitor);
    }

    private static void chmodAddPermissions(@Nonnull Path path, final @Nonnull Set<PosixFilePermission> filePermissions, final @Nonnull Set<PosixFilePermission> folderPermissions) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Given path " + path + " does not exist");
        }
        SimpleFileVisitor<Path> setReadOnlyFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    throw new IllegalStateException("No dir expected here: " + file);
                }
                Set<PosixFilePermission> existingPermissions = Files.getPosixFilePermissions(file, new LinkOption[0]);
                Files.setPosixFilePermissions(file, (Set<PosixFilePermission>)Sets.union(existingPermissions, (Set)filePermissions));
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Set<PosixFilePermission> existingPermissions = Files.getPosixFilePermissions(dir, new LinkOption[0]);
                Files.setPosixFilePermissions(dir, (Set<PosixFilePermission>)Sets.union(existingPermissions, (Set)folderPermissions));
                return super.preVisitDirectory(dir, attrs);
            }
        };
        Files.walkFileTree(path, (FileVisitor<? super Path>)setReadOnlyFileVisitor);
    }
}

