/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.util;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    protected static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static void get(URL url, Path destFile) throws IOException {
        HttpURLConnection cnn = (HttpURLConnection)url.openConnection();
        int responseCode = cnn.getResponseCode();
        Preconditions.checkState((responseCode == 200 ? 1 : 0) != 0, (String)"Unexpected response code {}\u00a0for {}", (Object[])new Object[]{responseCode, url});
        InputStream in = cnn.getInputStream();
        OutputStream out = Files.newOutputStream(destFile, new OpenOption[0]);
        long length = ByteStreams.copy((InputStream)in, (OutputStream)out);
        logger.debug("Copied {} in {}: {}\u00a0bytes", new Object[]{url, destFile, length});
    }
}

