/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manifests {
    private static final Logger logger = LoggerFactory.getLogger(Manifests.class);

    @Nullable
    public static Manifest getManifest(@Nonnull Class clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            logger.trace("No CodeSource found for {}", (Object)clazz);
            return null;
        }
        URL location = codeSource.getLocation();
        File file = new File(location.getFile());
        if (!file.exists()) {
            logger.warn("CodeSource location for {} does not exist: {}", (Object)clazz, (Object)location.getFile());
            return null;
        }
        try {
            logger.trace("Load jar {}", (Object)file);
            JarFile jarFile = new JarFile(file);
            return jarFile.getManifest();
        }
        catch (Exception e) {
            logger.warn("Exception retrieving manifest for {} in {}", new Object[]{clazz, location.getFile(), e});
            return null;
        }
    }

    @Nullable
    public static String getAttribute(@Nonnull Class clazz, @Nonnull String attribute, @Nullable String defaultValue) {
        Manifest manifest = Manifests.getManifest(clazz);
        if (manifest == null) {
            logger.debug("No manifest found for {}", (Object)clazz);
            return defaultValue;
        }
        String value = manifest.getMainAttributes().getValue(attribute);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Nullable
    public static String getAttribute(@Nonnull Class clazz, @Nonnull String attribute) {
        return Manifests.getAttribute(clazz, attribute, null);
    }
}

