/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.util;

import com.cloudbees.clickstack.domain.environment.Environment;
import com.cloudbees.clickstack.util.Strings2;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineUtils.class);

    public static Environment argumentsToEnvironment(@Nonnull String[] args) {
        Path appDir = CommandLineUtils.getOptionAsPath("app_dir", args);
        Path clickstackDir = CommandLineUtils.getOptionAsPath("plugin_dir", args, FileSystems.getDefault().getPath(".", new String[0]));
        Path packageDir = CommandLineUtils.getOptionAsPath("pkg_dir", args);
        String appUser = CommandLineUtils.getOption("app_user", args, System.getProperty("user.name"));
        String appId = CommandLineUtils.getOption("app_id", args);
        int appPort = CommandLineUtils.getOptionAsInt("app_port", args);
        Path genappDir = appDir.resolve(".genapp");
        Path controlDir = CommandLineUtils.getOptionAsPath("control_dir", args, genappDir.resolve("control"));
        Path logDir = CommandLineUtils.getOptionAsPath("log_dir", args, genappDir.resolve("log"));
        return new Environment(appDir, clickstackDir, packageDir, appUser, appId, appPort, controlDir, logDir);
    }

    @Nonnull
    public static String getOption(@Nonnull String name, @Nonnull String[] args) throws NoSuchElementException {
        return CommandLineUtils.getOption(name, args, true, true);
    }

    @Nullable
    public static String getOption(@Nonnull String name, @Nonnull String[] args, @Nullable String defaultValue) throws NoSuchElementException {
        try {
            return CommandLineUtils.getOption(name, args, true, true);
        }
        catch (NoSuchElementException e) {
            logger.info("Parameter '{}' not found, use default value {}", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
    }

    @Nonnull
    public static Path getOptionAsPath(@Nonnull String name, @Nonnull String[] args) throws NoSuchElementException {
        return FileSystems.getDefault().getPath(CommandLineUtils.getOption(name, args, true, true), new String[0]);
    }

    @Nullable
    public static Path getOptionAsPath(@Nonnull String name, @Nonnull String[] args, @Nullable Path defaultValue) throws NoSuchElementException {
        try {
            return FileSystems.getDefault().getPath(CommandLineUtils.getOption(name, args, true, true), new String[0]);
        }
        catch (NoSuchElementException e) {
            logger.info("Parameter '{}' not found, use default value {}", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
    }

    public static int getOptionAsInt(@Nonnull String name, @Nonnull String[] args) throws NoSuchElementException {
        String value = CommandLineUtils.getOption(name, args, true, true);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            NumberFormatException e = new NumberFormatException("Invalid numeric option '" + name + "'='" + value + "'");
            e.initCause(nfe);
            throw e;
        }
    }

    @Nonnull
    public static String getOption(@Nonnull String name, @Nonnull String[] args, boolean defaultToSystemProperty, boolean defaultToEnvironmentVariable) throws NoSuchElementException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (Strings2.beginWith(arg, "--")) {
                arg = arg.substring(1);
            }
            if (arg.equals("-" + name)) {
                if (i + 1 >= args.length) continue;
                return args[i + 1];
            }
            if (!Strings2.beginWith(arg, "-" + name + "=")) continue;
            return Strings2.substringAfterFirst(arg, '=');
        }
        if (defaultToSystemProperty && System.getProperty(name) != null) {
            return System.getProperty(name);
        }
        if (defaultToEnvironmentVariable && System.getenv(name) != null) {
            return System.getenv(name);
        }
        throw new NoSuchElementException("Argument '" + name + "' not found in " + Arrays.asList(args));
    }
}

