/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.clickstack.domain.environment;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    public static final String DEFAULT_JAVA_VERSION = "1.7";
    private static final Pattern VARIABLE = Pattern.compile("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_.]+\\}|\\$)");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FileSystem fs = FileSystems.getDefault();
    @Nonnull
    public final Path appDir;
    @Nonnull
    public final Path clickstackDir;
    @Nonnull
    public final Path packageDir;
    @Nonnull
    public final String appUser;
    @Nonnull
    public final String appId;
    public final int appPort;
    @Nonnull
    public final Path controlDir;
    @Nonnull
    public final Path logDir;
    @Nonnull
    public final Path genappDir;
    @Nonnull
    public final Path appExtraFiles;
    public Path javaHome;

    public Environment(@Nonnull Path appDir, @Nonnull Path clickstackDir, @Nonnull Path packageDir, @Nonnull String appUser, @Nonnull String appId, int appPort) {
        this(appDir, clickstackDir, packageDir, appUser, appId, appPort, appDir.resolve(".genapp/control"), appDir.resolve(".genapp/log"));
    }

    public Environment(@Nonnull Path appDir, @Nonnull Path clickstackDir, @Nonnull Path packageDir, @Nonnull String appUser, @Nonnull String appId, int appPort, @Nonnull Path controlDir, @Nonnull Path logDir) {
        this.appDir = appDir;
        this.clickstackDir = clickstackDir;
        this.packageDir = packageDir;
        this.appUser = appUser;
        this.appId = appId;
        this.appPort = appPort;
        this.controlDir = controlDir;
        this.logDir = logDir;
        this.genappDir = appDir.resolve(".genapp");
        this.appExtraFiles = appDir.resolve("app-extra-files");
    }

    public String toString() {
        return "Environment{, \n appUser='" + this.appUser + '\'' + ", \n" + " appId='" + this.appId + '\'' + ", \n" + " appPort=" + this.appPort + ", \n" + " appDir=" + this.appDir.toAbsolutePath() + ", \n" + " logDir=" + this.logDir.toAbsolutePath() + ", \n" + " genappDir=" + this.genappDir.toAbsolutePath() + ", \n" + " controlDir=" + this.controlDir.toAbsolutePath() + ", \n" + " clickstackDir=" + this.clickstackDir.toAbsolutePath() + ", \n" + " packageDir=" + this.packageDir.toAbsolutePath() + ", \n" + '}';
    }

    public String expand(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int idx = 0;
        Matcher m;
        while ((m = VARIABLE.matcher(s)).find(idx)) {
            String value;
            String key = m.group().substring(1);
            if (key.charAt(0) == '$') {
                value = "$";
            } else {
                if (key.charAt(0) == '{') {
                    key = key.substring(1, key.length() - 1);
                }
                value = this.resolve(key);
            }
            if (value == null) {
                idx = m.end();
                continue;
            }
            s = s.substring(0, m.start()) + value + s.substring(m.end());
            idx = m.start() + value.length();
        }
        return s;
    }

    private String resolve(String key) {
        switch (key) {
            case "app_dir": {
                return this.appDir.toAbsolutePath().toString();
            }
            case "plugin_dir": {
                return this.clickstackDir.toAbsolutePath().toString();
            }
            case "pkg_dir": {
                return this.packageDir.toAbsolutePath().toString();
            }
            case "app_user": {
                return this.appUser;
            }
            case "app_id": {
                return this.appId;
            }
            case "app_port": {
                return String.valueOf(this.appPort);
            }
            case "control_dir": {
                return this.controlDir.toAbsolutePath().toString();
            }
            case "log_dir": {
                return this.logDir.toAbsolutePath().toString();
            }
            case "genapp_dir": {
                return this.genappDir.toAbsolutePath().toString();
            }
            case "app-extra-files": {
                return this.appExtraFiles.toAbsolutePath().toString();
            }
        }
        return key;
    }
}

