/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.run;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudBeesAgent {
    private static final Logger logger = Logger.getLogger(CloudBeesAgent.class.getName());

    public static void main(String[] args) {
        if (args.length == 1) {
            CloudBeesAgent.premain(args[0], null);
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        if (agentArgs == null) {
            logger.severe("Properties file not passed as Java Agent arg, don't load properties");
            return;
        }
        List<String> propertiesFiles = CloudBeesAgent.extractPropertiesFilePathsWithBackwardCompatibility(agentArgs);
        for (String propertiesFilePath : propertiesFiles) {
            try {
                CloudBeesAgent.loadSystemProperties(propertiesFilePath);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failure load properties from " + agentArgs, e);
            }
        }
    }

    private static List<String> extractPropertiesFilePathsWithBackwardCompatibility(String agentArgs) {
        String[] args;
        HashMap<String, String> argumentsByName = new HashMap<String, String>();
        for (String arg : args = agentArgs.split(",")) {
            String[] parts = arg.split(":");
            if (parts.length == 2) {
                argumentsByName.put(parts[0], parts[1]);
                continue;
            }
            logger.fine("Ignore argument " + arg);
        }
        String propFileName = (String)argumentsByName.get("sys_prop");
        List<String> results = propFileName == null ? Arrays.asList(agentArgs.split(",")) : Collections.singletonList(propFileName);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSystemProperties(String propertiesFilePath) throws IOException {
        if (propertiesFilePath == null) {
            logger.severe("System properties file not defined with parameter sys_prop");
            return;
        }
        File propertyFile = new File(propertiesFilePath);
        if (!propertyFile.exists()) {
            logger.severe("Property file not found: path=" + propertiesFilePath + ", absolutePath=" + propertyFile.getAbsolutePath());
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(propertyFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("=");
                if (idx > -1) {
                    String name = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                        logger.fine("unwrapped double quotes around value=" + value + "]");
                    }
                    logger.finest("Process name=" + name + ", rawValue=" + value + "]");
                    value = value.replaceAll("\\\\\"", "\"");
                    logger.fine("un-escaped \\\" to \" value=" + value + "]");
                    value = value.replaceAll("\\\\\\\\", "\\\\");
                    logger.fine("un-escaped \\\\ to \\ value=" + value + "]");
                    logger.fine("System.setProperty(" + name + ", " + value + ")");
                    System.setProperty(name, value);
                    continue;
                }
                logger.fine("Ignore line " + line);
            }
            logger.info("Java System Properties loaded from " + propertyFile.getAbsolutePath());
        }
        finally {
            reader.close();
        }
    }
}

