/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

public abstract class CachingReference<E> {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private long lastCreationInNanos;
    private long timeToLiveInNanos;
    private E object;

    public CachingReference(long timeToLiveInNanos) {
        this.timeToLiveInNanos = timeToLiveInNanos;
    }

    public CachingReference(long timeToLive, TimeUnit timeToLiveUnit) {
        this(TimeUnit.NANOSECONDS.convert(timeToLive, timeToLiveUnit));
    }

    @Nullable
    protected abstract E newObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public E get() {
        this.rwl.readLock().lock();
        try {
            if (System.nanoTime() - this.lastCreationInNanos > this.timeToLiveInNanos) {
                this.rwl.readLock().unlock();
                this.rwl.writeLock().lock();
                try {
                    if (System.nanoTime() - this.lastCreationInNanos > this.timeToLiveInNanos) {
                        this.object = this.newObject();
                        this.lastCreationInNanos = System.nanoTime();
                    }
                    this.rwl.readLock().lock();
                }
                finally {
                    this.rwl.writeLock().unlock();
                }
            }
            E e = this.object;
            return e;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public String toString() {
        return "CachingReference[" + this.object + "]";
    }
}

