/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog;

import com.cloudbees.syslog.SDParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SDElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String[] RESERVED_SDID = new String[]{"timeQuality", "tzKnown", "isSynced", "syncAccuracy"};
    private String sdID;
    private List<SDParam> sdParams = new ArrayList<SDParam>();

    public SDElement(String sdID) {
        this.validateSDID(sdID);
        this.sdID = sdID;
    }

    public SDElement(String sdID, SDParam ... sdParams) {
        this.validateSDID(sdID);
        this.sdID = sdID;
        this.sdParams.addAll(Arrays.asList(sdParams));
    }

    public String getSdID() {
        return this.sdID;
    }

    public List<SDParam> getSdParams() {
        return this.sdParams;
    }

    public void setSdParams(List<SDParam> sdParams) {
        if (null == sdParams) {
            throw new IllegalArgumentException("sdParams list cannot be null");
        }
        this.sdParams.addAll(sdParams);
    }

    public SDElement addSDParam(String paramName, String paramValue) {
        return this.addSDParam(new SDParam(paramName, paramValue));
    }

    public SDElement addSDParam(SDParam sdParam) {
        this.sdParams.add(sdParam);
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.sdID);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SDElement other = (SDElement)obj;
        return Objects.equals(this.sdID, other.sdID);
    }

    private void validateSDID(String sdName) {
        if (null == sdName) {
            throw new IllegalArgumentException("SD-ID cannot be null");
        }
        if (sdName.length() > 32) {
            throw new IllegalArgumentException("SD-ID must be less than 32 characters: " + sdName);
        }
        if (sdName.contains("=")) {
            throw new IllegalArgumentException("SD-ID cannot contain '='");
        }
        if (sdName.contains(" ")) {
            throw new IllegalArgumentException("SD-ID cannot contain ' '");
        }
        if (sdName.contains("]")) {
            throw new IllegalArgumentException("SD-ID cannot contain ']'");
        }
        if (sdName.contains("\"")) {
            throw new IllegalArgumentException("SD-ID cannot contain '\"'");
        }
        if (!sdName.contains("@")) {
            boolean found = false;
            for (String rn : RESERVED_SDID) {
                if (!rn.equals(sdName)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("SD-ID is not known registered SDID: " + sdName);
            }
        }
    }
}

