/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.async;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.AzureBlobImportRequest;
import com.cloudconvert.dto.request.GoogleCloudStorageImportRequest;
import com.cloudconvert.dto.request.OpenStackImportRequest;
import com.cloudconvert.dto.request.S3ImportRequest;
import com.cloudconvert.dto.request.SftpImportRequest;
import com.cloudconvert.dto.request.UploadImportRequest;
import com.cloudconvert.dto.request.UrlImportRequest;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.AsyncResult;
import com.cloudconvert.dto.result.CompletedAsyncResult;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.executor.AsyncRequestExecutor;
import com.cloudconvert.resource.AbstractImportFilesResource;
import com.cloudconvert.resource.async.AsyncTasksResource;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncImportFilesResource
extends AbstractImportFilesResource<AsyncResult<TaskResponse>> {
    private static final Logger log = LoggerFactory.getLogger(AsyncImportFilesResource.class);
    private final AsyncRequestExecutor asyncRequestExecutor;
    private final AsyncTasksResource asyncTasksResource;

    public AsyncImportFilesResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, AsyncRequestExecutor asyncRequestExecutor, AsyncTasksResource asyncTasksResource) {
        super(settingsProvider, objectMapperProvider);
        this.asyncRequestExecutor = asyncRequestExecutor;
        this.asyncTasksResource = asyncTasksResource;
    }

    @Override
    public AsyncResult<TaskResponse> url(@NotNull UrlImportRequest urlImportRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getUrlHttpUriRequest(urlImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull UploadImportRequest uploadImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)"import", (Object)"upload"));
        HttpEntity httpEntity = this.getHttpEntity(uploadImportRequest);
        HttpUriRequest httpUriRequest = this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
        return this.asyncRequestExecutor.execute(httpUriRequest, TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull UploadImportRequest uploadImportRequest, @NotNull File file) throws IOException, URISyntaxException {
        return this.upload((AsyncResult<TaskResponse>)this.upload(uploadImportRequest), file);
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull AsyncResult<TaskResponse> TaskResponseAsyncResult, @NotNull File file) throws IOException, URISyntaxException {
        try {
            Result<TaskResponse> TaskResponseResult = TaskResponseAsyncResult.get();
            if (201 == TaskResponseResult.getStatus()) {
                TaskResponse taskResponse = TaskResponseResult.getBody();
                return this.upload(taskResponse.getId(), taskResponse.getResult().getForm(), file);
            }
            return CompletedAsyncResult.builder().result(Result.builder().status(TaskResponseResult.getStatus()).message(TaskResponseResult.getMessage()).build()).build();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull String taskId, @NotNull TaskResponse.Result.Form taskResponseResultForm, @NotNull File file) throws IOException, URISyntaxException {
        try {
            URI multipartUri = new URI(taskResponseResultForm.getUrl());
            HttpEntity multipartHttpEntity = this.getMultipartHttpEntity(taskResponseResultForm, file);
            HttpUriRequest multipartHttpUriRequest = this.getHttpUriRequest(HttpPost.class, multipartUri, multipartHttpEntity);
            return this.uploadPostProcess(taskId, this.asyncRequestExecutor.execute(multipartHttpUriRequest, VOID_TYPE_REFERENCE));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull UploadImportRequest uploadImportRequest, @NotNull InputStream inputStream) throws IOException, URISyntaxException {
        return this.upload((AsyncResult<TaskResponse>)this.upload(uploadImportRequest), inputStream);
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull AsyncResult<TaskResponse> TaskResponseAsyncResult, @NotNull InputStream inputStream) throws IOException, URISyntaxException {
        try {
            Result<TaskResponse> TaskResponseResult = TaskResponseAsyncResult.get();
            if (201 == TaskResponseResult.getStatus()) {
                TaskResponse taskResponse = TaskResponseResult.getBody();
                return this.upload(taskResponse.getId(), taskResponse.getResult().getForm(), inputStream);
            }
            return CompletedAsyncResult.builder().result(Result.builder().status(TaskResponseResult.getStatus()).message(TaskResponseResult.getMessage()).build()).build();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public AsyncResult<TaskResponse> upload(@NotNull String taskId, @NotNull TaskResponse.Result.Form taskResponseResultForm, @NotNull InputStream inputStream) throws IOException, URISyntaxException {
        try {
            URI multipartUri = new URI(taskResponseResultForm.getUrl());
            HttpEntity multipartHttpEntity = this.getMultipartHttpEntity(taskResponseResultForm, inputStream);
            HttpUriRequest multipartHttpUriRequest = this.getHttpUriRequest(HttpPost.class, multipartUri, multipartHttpEntity);
            return this.uploadPostProcess(taskId, this.asyncRequestExecutor.execute(multipartHttpUriRequest, VOID_TYPE_REFERENCE));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private AsyncResult<TaskResponse> uploadPostProcess(String taskId, AsyncResult<Void> multipartVoidAsyncResult) throws IOException, URISyntaxException, InterruptedException, ExecutionException {
        Result<Void> multipartVoidResult = multipartVoidAsyncResult.get();
        if (201 == multipartVoidResult.getStatus()) {
            return this.asyncTasksResource.show(taskId);
        }
        if (303 == multipartVoidResult.getStatus()) {
            URI redirectUri = new URI(multipartVoidResult.getHeaders().get("Location"));
            HttpUriRequest redirectHttpUriRequest = this.getHttpUriRequest(HttpGet.class, redirectUri);
            AsyncResult redirectVoidAsyncResult = this.asyncRequestExecutor.execute(redirectHttpUriRequest, VOID_TYPE_REFERENCE);
            Result redirectVoidResult = redirectVoidAsyncResult.get();
            if (201 == redirectVoidResult.getStatus()) {
                return this.asyncTasksResource.show(taskId);
            }
            return CompletedAsyncResult.builder().result(Result.builder().status(redirectVoidResult.getStatus()).message(redirectVoidResult.getMessage()).build()).build();
        }
        return CompletedAsyncResult.builder().result(Result.builder().status(multipartVoidResult.getStatus()).message(multipartVoidResult.getMessage()).build()).build();
    }

    @Override
    public AsyncResult<TaskResponse> s3(@NotNull S3ImportRequest s3ImportRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getS3HttpUriRequest(s3ImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> azureBlob(@NotNull AzureBlobImportRequest azureBlobImportRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getAzureBlobHttpUriRequest(azureBlobImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> googleCloudStorage(@NotNull GoogleCloudStorageImportRequest googleCloudStorageImportRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getGoogleCloudHttpUriRequest(googleCloudStorageImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> openStack(@NotNull OpenStackImportRequest openStackImportRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getOpenStackHttpUriRequest(openStackImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> sftp(@NotNull SftpImportRequest sftpImportRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getSftpHttpUriRequest(sftpImportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.asyncRequestExecutor.close();
        this.asyncTasksResource.close();
    }
}

