/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.sync;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.WebhookRequest;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.WebhookResponse;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.executor.RequestExecutor;
import com.cloudconvert.resource.AbstractWebhooksResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Pagination;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebhookResource
extends AbstractWebhooksResource<Result<WebhookResponse>, Result<Pageable<WebhookResponse>>, Result<Void>> {
    private final RequestExecutor requestExecutor;

    public WebhookResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, RequestExecutor requestExecutor) {
        super(settingsProvider, objectMapperProvider);
        this.requestExecutor = requestExecutor;
    }

    @Override
    public Result<WebhookResponse> create(@NotNull WebhookRequest webhookRequest) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getCreateHttpUriRequest(webhookRequest), WEBHOOKS_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<Pageable<WebhookResponse>> list() throws IOException, URISyntaxException {
        return this.list((Map)ImmutableMap.of());
    }

    @Override
    public Result<Pageable<WebhookResponse>> list(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return this.list((Map)filters, (Pagination)null);
    }

    @Override
    public Result<Pageable<WebhookResponse>> list(@NotNull Map<Filter, String> filters, @Nullable Pagination pagination) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getListHttpUriRequest(filters, pagination), WEBHOOKS_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public Result<Void> delete(@NotNull String webhookId) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getDeleteHttpUriRequest(webhookId), VOID_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.requestExecutor.close();
    }
}

