/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.AzureBlobExportRequest;
import com.cloudconvert.dto.request.GoogleCloudStorageExportRequest;
import com.cloudconvert.dto.request.OpenStackExportRequest;
import com.cloudconvert.dto.request.S3ExportRequest;
import com.cloudconvert.dto.request.SftpExportRequest;
import com.cloudconvert.dto.request.UrlExportRequest;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.AbstractResult;
import com.cloudconvert.resource.AbstractResource;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExportFilesResource<TRAR extends AbstractResult<TaskResponse>>
extends AbstractResource {
    public static final String PATH_SEGMENT_EXPORT = "export";
    public static final String PATH_SEGMENT_URL = "url";
    public static final String PATH_SEGMENT_S3 = "s3";
    public static final List<String> PATH_SEGMENTS_AZURE_BLOB = ImmutableList.of((Object)"azure", (Object)"blob");
    public static final String PATH_SEGMENT_GOOGLE_CLOUD_STORAGE = "google-cloud-storage";
    public static final String PATH_SEGMENT_OPENSTACK = "openstack";
    public static final String PATH_SEGMENT_SFTP = "sftp";

    public AbstractExportFilesResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider) {
        super(settingsProvider, objectMapperProvider);
    }

    public abstract TRAR url(@NotNull UrlExportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getUrlHttpUriRequest(@NotNull UrlExportRequest urlExportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_EXPORT, (Object)PATH_SEGMENT_URL));
        HttpEntity httpEntity = this.getHttpEntity(urlExportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR s3(@NotNull S3ExportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getS3HttpUriRequest(@NotNull S3ExportRequest s3ExportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_EXPORT, (Object)PATH_SEGMENT_S3));
        HttpEntity httpEntity = this.getHttpEntity(s3ExportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR azureBlob(@NotNull AzureBlobExportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getAzureBlobHttpUriRequest(@NotNull AzureBlobExportRequest azureBlobExportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.builder().add((Object)PATH_SEGMENT_EXPORT).addAll(PATH_SEGMENTS_AZURE_BLOB).build());
        HttpEntity httpEntity = this.getHttpEntity(azureBlobExportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR googleCloudStorage(@NotNull GoogleCloudStorageExportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getGoogleCloudStorageHttpUriRequest(@NotNull GoogleCloudStorageExportRequest googleCloudStorageExportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_EXPORT, (Object)PATH_SEGMENT_GOOGLE_CLOUD_STORAGE));
        HttpEntity httpEntity = this.getHttpEntity(googleCloudStorageExportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR openStack(@NotNull OpenStackExportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getOpenStackStorageHttpUriRequest(@NotNull OpenStackExportRequest openStackExportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_EXPORT, (Object)PATH_SEGMENT_OPENSTACK));
        HttpEntity httpEntity = this.getHttpEntity(openStackExportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR sftp(@NotNull SftpExportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getSftpStorageHttpUriRequest(@NotNull SftpExportRequest sftpExportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_EXPORT, (Object)PATH_SEGMENT_SFTP));
        HttpEntity httpEntity = this.getHttpEntity(sftpExportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }
}

