/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.AzureBlobImportRequest;
import com.cloudconvert.dto.request.GoogleCloudStorageImportRequest;
import com.cloudconvert.dto.request.OpenStackImportRequest;
import com.cloudconvert.dto.request.S3ImportRequest;
import com.cloudconvert.dto.request.SftpImportRequest;
import com.cloudconvert.dto.request.UploadImportRequest;
import com.cloudconvert.dto.request.UrlImportRequest;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.AbstractResult;
import com.cloudconvert.resource.AbstractResource;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImportFilesResource<TRAR extends AbstractResult<TaskResponse>>
extends AbstractResource {
    public static final String PATH_SEGMENT_IMPORT = "import";
    public static final String PATH_SEGMENT_URL = "url";
    public static final String PATH_SEGMENT_UPLOAD = "upload";
    public static final String PATH_SEGMENT_S3 = "s3";
    public static final List<String> PATH_SEGMENTS_AZURE_BLOB = ImmutableList.of((Object)"azure", (Object)"blob");
    public static final String PATH_SEGMENT_GOOGLE_CLOUD_STORAGE = "google-cloud-storage";
    public static final String PATH_SEGMENT_OPENSTACK = "openstack";
    public static final String PATH_SEGMENT_SFTP = "sftp";
    private final Tika tika = new Tika();

    public AbstractImportFilesResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider) {
        super(settingsProvider, objectMapperProvider);
    }

    public abstract TRAR url(@NotNull UrlImportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getUrlHttpUriRequest(@NotNull UrlImportRequest urlImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_IMPORT, (Object)PATH_SEGMENT_URL));
        HttpEntity httpEntity = this.getHttpEntity(urlImportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR upload(@NotNull UploadImportRequest var1) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull UploadImportRequest var1, @NotNull File var2) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull TRAR var1, @NotNull File var2) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull String var1, @NotNull TaskResponse.Result.Form var2, @NotNull File var3) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull UploadImportRequest var1, @NotNull InputStream var2) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull UploadImportRequest var1, @NotNull InputStream var2, @NotNull String var3) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull TRAR var1, @NotNull InputStream var2) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull TRAR var1, @NotNull InputStream var2, @NotNull String var3) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull String var1, @NotNull TaskResponse.Result.Form var2, @NotNull InputStream var3) throws IOException, URISyntaxException;

    public abstract TRAR upload(@NotNull String var1, @NotNull TaskResponse.Result.Form var2, @NotNull InputStream var3, @NotNull String var4) throws IOException, URISyntaxException;

    public abstract TRAR s3(@NotNull S3ImportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getS3HttpUriRequest(@NotNull S3ImportRequest s3ImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_IMPORT, (Object)PATH_SEGMENT_S3));
        HttpEntity httpEntity = this.getHttpEntity(s3ImportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR azureBlob(@NotNull AzureBlobImportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getAzureBlobHttpUriRequest(@NotNull AzureBlobImportRequest azureBlobImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.builder().add((Object)PATH_SEGMENT_IMPORT).addAll(PATH_SEGMENTS_AZURE_BLOB).build());
        HttpEntity httpEntity = this.getHttpEntity(azureBlobImportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR googleCloudStorage(@NotNull GoogleCloudStorageImportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getGoogleCloudHttpUriRequest(@NotNull GoogleCloudStorageImportRequest googleCloudStorageImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_IMPORT, (Object)PATH_SEGMENT_GOOGLE_CLOUD_STORAGE));
        HttpEntity httpEntity = this.getHttpEntity(googleCloudStorageImportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR openStack(@NotNull OpenStackImportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getOpenStackHttpUriRequest(@NotNull OpenStackImportRequest openStackImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_IMPORT, (Object)PATH_SEGMENT_OPENSTACK));
        HttpEntity httpEntity = this.getHttpEntity(openStackImportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract TRAR sftp(@NotNull SftpImportRequest var1) throws IOException, URISyntaxException;

    protected HttpUriRequest getSftpHttpUriRequest(@NotNull SftpImportRequest sftpImportRequest) throws IOException, URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_IMPORT, (Object)PATH_SEGMENT_SFTP));
        HttpEntity httpEntity = this.getHttpEntity(sftpImportRequest);
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    protected HttpEntity getMultipartHttpEntity(TaskResponse.Result.Form uploadImportResponseResultForm, File file) throws IOException {
        return this.getMultipartHttpEntity(uploadImportResponseResultForm, file.getName(), new FileInputStream(file));
    }

    protected HttpEntity getMultipartHttpEntity(TaskResponse.Result.Form uploadImportResponseResultForm, InputStream inputStream) throws IOException {
        try {
            MimeType mimeType = MimeTypes.getDefaultMimeTypes().forName(this.tika.detect(inputStream));
            return this.getMultipartHttpEntity(uploadImportResponseResultForm, "file" + mimeType.getExtension(), inputStream);
        }
        catch (MimeTypeException e) {
            throw new IOException(e);
        }
    }

    protected HttpEntity getMultipartHttpEntity(TaskResponse.Result.Form uploadImportResponseResultForm, @NotNull String filename, InputStream inputStream) throws IOException {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA);
        uploadImportResponseResultForm.getParameters().forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)multipartEntityBuilder).addTextBody(arg_0, arg_1));
        return new BufferedHttpEntity(multipartEntityBuilder.addPart(FormBodyPartBuilder.create((String)"file", (ContentBody)new InputStreamBody((InputStream)new BufferedInputStream(inputStream), filename)).build()).build());
    }
}

