/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.dto.result;

public class Status {
    private int code;
    private String reason;

    public boolean isInformational() {
        return 100 <= this.code && this.code <= 199;
    }

    public boolean isSuccessful() {
        return 200 <= this.code && this.code <= 299;
    }

    public boolean isRedirection() {
        return 300 <= this.code && this.code <= 399;
    }

    public boolean isClientError() {
        return 400 <= this.code && this.code <= 499;
    }

    public boolean isServerError() {
        return 500 <= this.code && this.code <= 599;
    }

    Status(int code, String reason) {
        this.code = code;
        this.reason = reason;
    }

    public static StatusBuilder builder() {
        return new StatusBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public static class StatusBuilder {
        private int code;
        private String reason;

        StatusBuilder() {
        }

        public StatusBuilder code(int code) {
            this.code = code;
            return this;
        }

        public StatusBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Status build() {
            return new Status(this.code, this.reason);
        }

        public String toString() {
            return "Status.StatusBuilder(code=" + this.code + ", reason=" + this.reason + ")";
        }
    }
}

