/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.async;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.TaskRequest;
import com.cloudconvert.dto.response.JobResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.result.AsyncResult;
import com.cloudconvert.executor.AsyncRequestExecutor;
import com.cloudconvert.resource.AbstractJobsResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.Pagination;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncJobsResource
extends AbstractJobsResource<AsyncResult<JobResponse>, AsyncResult<Pageable<JobResponse>>, AsyncResult<Void>> {
    private static final Logger log = LoggerFactory.getLogger(AsyncJobsResource.class);
    private final AsyncRequestExecutor asyncRequestExecutor;

    public AsyncJobsResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, AsyncRequestExecutor asyncRequestExecutor) {
        super(settingsProvider, objectMapperProvider);
        this.asyncRequestExecutor = asyncRequestExecutor;
    }

    @Override
    public AsyncResult<JobResponse> create(@NotNull Map<String, TaskRequest> tasks) throws IOException, URISyntaxException {
        return this.create((Map)tasks, "");
    }

    @Override
    public AsyncResult<JobResponse> create(@NotNull Map<String, TaskRequest> tasks, @NotNull String tag) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getCreateHttpUriRequest(tasks, tag), JOB_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<JobResponse> show(@NotNull String jobId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getShowHttpUriRequest(jobId), JOB_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<JobResponse> wait(@NotNull String jobId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getWaitHttpUriRequest(jobId), JOB_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Pageable<JobResponse>> list() throws IOException, URISyntaxException {
        return this.list((Map)ImmutableMap.of());
    }

    @Override
    public AsyncResult<Pageable<JobResponse>> list(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return this.list((Map)filters, (List)ImmutableList.of());
    }

    @Override
    public AsyncResult<Pageable<JobResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException {
        return this.list((Map)filters, (List)includes, (Pagination)null);
    }

    @Override
    public AsyncResult<Pageable<JobResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Pagination pagination) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getListHttpUriRequest(filters, includes, pagination), JOB_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Void> delete(@NotNull String jobId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getDeleteHttpUriRequest(jobId), VOID_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.asyncRequestExecutor.close();
    }
}

