/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.TaskRequest;
import com.cloudconvert.dto.response.JobResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.result.AbstractResult;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.resource.AbstractResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.Pagination;
import com.cloudconvert.resource.params.converter.FiltersToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.IncludesToNameValuePairsConverter;
import com.cloudconvert.resource.params.converter.PaginationToNameValuePairsConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobsResource<JRAR extends AbstractResult<JobResponse>, JRPAR extends AbstractResult<Pageable<JobResponse>>, VAR extends AbstractResult<Void>>
extends AbstractResource {
    public static final String PATH_SEGMENT_JOBS = "jobs";
    public static final String PATH_SEGMENT_WAIT = "wait";
    private final IncludesToNameValuePairsConverter includesToNameValuePairsConverter = new IncludesToNameValuePairsConverter();
    private final FiltersToNameValuePairsConverter filtersToNameValuePairsConverter = new FiltersToNameValuePairsConverter();
    private final PaginationToNameValuePairsConverter paginationToNameValuePairsConverter = new PaginationToNameValuePairsConverter();

    public AbstractJobsResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider) {
        super(settingsProvider, objectMapperProvider);
    }

    public abstract JRAR create(@NotNull Map<String, TaskRequest> var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract JRAR create(@NotNull Map<String, TaskRequest> var1, @NotNull String var2) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getCreateHttpUriRequest(@NotNull Map<String, TaskRequest> tasks, @NotNull String tag) throws IOException, URISyntaxException {
        HashMap<String, Map<String, Object>> tasksAsMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, TaskRequest> entry : tasks.entrySet()) {
            tasksAsMap.put(entry.getKey(), this.requestToMap(entry.getValue()));
        }
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_JOBS));
        HttpEntity httpEntity = this.getHttpEntity((Map<String, Object>)ImmutableMap.of((Object)"tasks", tasksAsMap, (Object)"tag", (Object)tag));
        return this.getHttpUriRequest(HttpPost.class, uri, httpEntity);
    }

    public abstract JRAR show(@NotNull String var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getShowHttpUriRequest(@NotNull String jobId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_JOBS, (Object)jobId));
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract JRAR wait(@NotNull String var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getWaitHttpUriRequest(@NotNull String jobId) throws URISyntaxException {
        URI uri = this.getSyncUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_JOBS, (Object)jobId));
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract JRPAR list() throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract JRPAR list(@NotNull Map<Filter, String> var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract JRPAR list(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    public abstract JRPAR list(@NotNull Map<Filter, String> var1, @NotNull List<Include> var2, @Nullable Pagination var3) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getListHttpUriRequest(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Pagination pagination) throws IOException, URISyntaxException {
        ImmutableList nameValuePairs = ImmutableList.builder().addAll(this.filtersToNameValuePairsConverter.convert(filters)).addAll(this.includesToNameValuePairsConverter.convert(includes)).addAll(this.paginationToNameValuePairsConverter.convert(pagination)).build();
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_JOBS), (List<NameValuePair>)nameValuePairs);
        return this.getHttpUriRequest(HttpGet.class, uri);
    }

    public abstract VAR delete(@NotNull String var1) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException;

    protected HttpUriRequest getDeleteHttpUriRequest(@NotNull String jobId) throws URISyntaxException {
        URI uri = this.getUri((List<String>)ImmutableList.of((Object)PATH_SEGMENT_JOBS, (Object)jobId));
        return this.getHttpUriRequest(HttpDelete.class, uri);
    }
}

