/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.sync;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.AzureBlobExportRequest;
import com.cloudconvert.dto.request.GoogleCloudStorageExportRequest;
import com.cloudconvert.dto.request.OpenStackExportRequest;
import com.cloudconvert.dto.request.S3ExportRequest;
import com.cloudconvert.dto.request.SftpExportRequest;
import com.cloudconvert.dto.request.UrlExportRequest;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.executor.RequestExecutor;
import com.cloudconvert.resource.AbstractExportFilesResource;
import java.io.IOException;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFilesResource
extends AbstractExportFilesResource<Result<TaskResponse>> {
    private static final Logger log = LoggerFactory.getLogger(ExportFilesResource.class);
    private final RequestExecutor requestExecutor;

    public ExportFilesResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, RequestExecutor requestExecutor) {
        super(settingsProvider, objectMapperProvider);
        this.requestExecutor = requestExecutor;
    }

    @Override
    public Result<TaskResponse> url(@NotNull UrlExportRequest urlExportRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getUrlHttpUriRequest(urlExportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> s3(@NotNull S3ExportRequest s3ExportRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getS3HttpUriRequest(s3ExportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> azureBlob(@NotNull AzureBlobExportRequest azureBlobExportRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getAzureBlobHttpUriRequest(azureBlobExportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> googleCloudStorage(@NotNull GoogleCloudStorageExportRequest googleCloudStorageExportRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getGoogleCloudStorageHttpUriRequest(googleCloudStorageExportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> openStack(@NotNull OpenStackExportRequest openStackExportRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getOpenStackStorageHttpUriRequest(openStackExportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<TaskResponse> sftp(@NotNull SftpExportRequest sftpExportRequest) throws IOException, URISyntaxException, CloudConvertClientException, CloudConvertServerException {
        return this.requestExecutor.execute(this.getSftpStorageHttpUriRequest(sftpExportRequest), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.requestExecutor.close();
    }
}

