/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.exception;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.dto.response.ErrorResponse;
import com.cloudconvert.dto.result.Status;
import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class CloudConvertException
extends Exception {
    private final Status status;
    private final Map<String, String> headers;
    private final ErrorResponse body;

    public CloudConvertException(Status status, Map<String, String> headers, final InputStream inputStream, ObjectMapperProvider objectMapperProvider) throws IOException {
        ByteSource byteSource = new ByteSource(){

            public InputStream openStream() throws IOException {
                return inputStream;
            }
        };
        this.status = status;
        this.headers = headers;
        this.body = (ErrorResponse)objectMapperProvider.provide().readValue(byteSource.asCharSource(Charsets.UTF_8).read(), ErrorResponse.class);
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ErrorResponse getBody() {
        return this.body;
    }
}

