/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.client.setttings;

import com.cloudconvert.client.setttings.SettingsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSettingsProvider
implements SettingsProvider {
    public static final String API_KEY = "CLOUDCONVERT_API_KEY";
    public static final String USE_SANDBOX = "CLOUDCONVERT_SANDBOX";
    public static final String WEBHOOK_SIGNING_SECRET = "CLOUDCONVERT_WEBHOOK_SIGNING_SECRET";
    public static final String API_URL_SANDBOX = "https://api.sandbox.cloudconvert.com/v2";
    public static final String API_URL_LIVE = "https://api.cloudconvert.com/v2";
    public static final String API_SYNC_URL_SANDBOX = "https://sync.api.sandbox.cloudconvert.com/v2";
    public static final String API_SYNC_URL_LIVE = "https://sync.api.cloudconvert.com/v2";
    private String apiKey;
    private String webhookSigningSecret;
    private String apiUrl;
    private String syncApiUrl;

    protected AbstractSettingsProvider(String apiKey, String webhookSigningSecret, String useSandbox) {
        this.init(apiKey, webhookSigningSecret, useSandbox);
    }

    protected AbstractSettingsProvider(@NotNull InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream tryWithResourceInputStream = inputStream;){
            Properties properties = new Properties();
            properties.load(tryWithResourceInputStream);
            this.init(properties.getProperty(API_KEY), properties.getProperty(WEBHOOK_SIGNING_SECRET), properties.getProperty(USE_SANDBOX));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void init(String apiKey, String webhookSigningSecret, String useSandbox) {
        this.apiKey = Optional.ofNullable(apiKey).orElseThrow(() -> new IllegalArgumentException("Could not resolve CLOUDCONVERT_API_KEY, make sure it is set correctly ..."));
        this.webhookSigningSecret = Optional.ofNullable(webhookSigningSecret).orElseThrow(() -> new IllegalArgumentException("Could not resolve CLOUDCONVERT_WEBHOOK_SIGNING_SECRET, make sure it is set correctly ..."));
        this.apiUrl = Boolean.parseBoolean(useSandbox) ? API_URL_SANDBOX : API_URL_LIVE;
        this.syncApiUrl = Boolean.parseBoolean(useSandbox) ? API_SYNC_URL_SANDBOX : API_SYNC_URL_LIVE;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getWebhookSigningSecret() {
        return this.webhookSigningSecret;
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public String getSyncApiUrl() {
        return this.syncApiUrl;
    }
}

