/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.dto.result;

import com.cloudconvert.dto.result.AsyncResult;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.exception.CloudConvertClientException;
import com.cloudconvert.exception.CloudConvertServerException;
import com.cloudconvert.extractor.ResultExtractor;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.jetbrains.annotations.Nullable;

public class FutureAsyncResult<T>
extends AsyncResult<T> {
    private ResultExtractor resultExtractor;
    private Future<HttpResponse> future;
    private TypeReference<T> typeReference;
    @Nullable
    private Result<T> result;

    @Override
    public Result<T> get() throws InterruptedException, ExecutionException, IOException, CloudConvertClientException, CloudConvertServerException {
        return this.extractResult(this.future.get());
    }

    @Override
    public Result<T> get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException, IOException, CloudConvertClientException, CloudConvertServerException {
        return this.extractResult(this.future.get(timeout, timeUnit));
    }

    private synchronized Result<T> extractResult(HttpResponse httpResponse) throws IOException, CloudConvertClientException, CloudConvertServerException {
        if (this.result == null) {
            this.result = this.resultExtractor.extract(httpResponse, this.typeReference);
        }
        return this.result;
    }

    @Generated
    FutureAsyncResult(ResultExtractor resultExtractor, Future<HttpResponse> future, TypeReference<T> typeReference, @Nullable Result<T> result) {
        this.resultExtractor = resultExtractor;
        this.future = future;
        this.typeReference = typeReference;
        this.result = result;
    }

    @Generated
    public static <T> FutureAsyncResultBuilder<T> builder() {
        return new FutureAsyncResultBuilder();
    }

    @Generated
    public static class FutureAsyncResultBuilder<T> {
        @Generated
        private ResultExtractor resultExtractor;
        @Generated
        private Future<HttpResponse> future;
        @Generated
        private TypeReference<T> typeReference;
        @Generated
        private Result<T> result;

        @Generated
        FutureAsyncResultBuilder() {
        }

        @Generated
        public FutureAsyncResultBuilder<T> resultExtractor(ResultExtractor resultExtractor) {
            this.resultExtractor = resultExtractor;
            return this;
        }

        @Generated
        public FutureAsyncResultBuilder<T> future(Future<HttpResponse> future) {
            this.future = future;
            return this;
        }

        @Generated
        public FutureAsyncResultBuilder<T> typeReference(TypeReference<T> typeReference) {
            this.typeReference = typeReference;
            return this;
        }

        @Generated
        public FutureAsyncResultBuilder<T> result(@Nullable Result<T> result) {
            this.result = result;
            return this;
        }

        @Generated
        public FutureAsyncResult<T> build() {
            return new FutureAsyncResult<T>(this.resultExtractor, this.future, this.typeReference, this.result);
        }

        @Generated
        public String toString() {
            return "FutureAsyncResult.FutureAsyncResultBuilder(resultExtractor=" + this.resultExtractor + ", future=" + this.future + ", typeReference=" + this.typeReference + ", result=" + this.result + ")";
        }
    }
}

